/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.fileDependency.FunctionTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.SpyJSIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyEventTreeNode
extends SimpleNode {
    private EventNode myEventNode;

    /*
     * WARNING - void declaration
     */
    public DependencyEventTreeNode(@NotNull TraceContext context, @NotNull FunctionTreeNode parent, @NotNull String streamId, long eventId, long l) {
        void hitCount;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/fileDependency/DependencyEventTreeNode", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/fileDependency/DependencyEventTreeNode", "<init>"));
        }
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/DependencyEventTreeNode", "<init>"));
        }
        super((SimpleNode)parent);
        EventTree eventTree = context.getCurrentEventTree();
        if (eventTree == null) {
            return;
        }
        PresentationData presentation = this.getPresentation();
        this.myEventNode = eventTree.getEventNodeByEventId(streamId, eventId);
        presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myEventNode != null) {
            presentation.addText(this.myEventNode.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setIcon(this.myEventNode.getIcon());
        } else {
            presentation.addText(TraceBundle.message("fileDependency.details.event.unknown", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setIcon(SpyJSIcons.Event);
        }
        presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(TraceBundle.message("fileDependency.details.event.hits", (long)hitCount), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public SimpleNode[] getChildren() {
        return new SimpleNode[0];
    }

    @Nullable
    public EventNode getEventNode() {
        return this.myEventNode;
    }
}

