/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.FunctionCombination;
import com.intellij.javascript.trace.execution.fileDependency.FunctionTreeNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileTreeNode
extends SimpleNode {
    private final FunctionTreeNode[] myChildren;

    public FileTreeNode(@NotNull TraceContext traceContext, @NotNull String streamId, @NotNull SimpleNode parent, @NotNull FileNode source, @NotNull RuntimeDependencyEdge edge) {
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode", "<init>"));
        }
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode", "<init>"));
        }
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode", "<init>"));
        }
        super(parent);
        PresentationData presentation = this.getPresentation();
        FileNode target = edge.getTarget();
        this.setIcon((Icon)JBUI.scale((JBUI.JBIcon)new MyIcon(10, source.getFileColor(), target.getFileColor())));
        presentation.addText(String.format(" %s -> %s", source.getShortFileName(), target.getShortFileName()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        List functionTreeNodes = ContainerUtil.map((Object[])edge.getFunctionCombinations(), combination -> {
            if (traceContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode", "lambda$new$0"));
            }
            if (streamId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode", "lambda$new$0"));
            }
            return new FunctionTreeNode(traceContext, streamId, this, (FunctionCombination)combination);
        });
        this.myChildren = functionTreeNodes.toArray(new FunctionTreeNode[functionTreeNodes.size()]);
    }

    public SimpleNode[] getChildren() {
        return this.myChildren;
    }

    private static class MyIcon
    extends EmptyIcon {
        @NotNull
        private final Color myColor1;
        @NotNull
        private final Color myColor2;
        private final int mySize;

        public MyIcon(int size, @NotNull Color color1, @NotNull Color color2) {
            if (color1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color1", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode$MyIcon", "<init>"));
            }
            if (color2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color2", "com/intellij/javascript/trace/execution/fileDependency/FileTreeNode$MyIcon", "<init>"));
            }
            super(size * 2 + 2, size);
            this.mySize = size;
            this.myColor1 = color1;
            this.myColor2 = color2;
        }

        public void paintIcon(Component component, Graphics g, int x, int y) {
            int h = this.getIconHeight();
            GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.myColor1);
            g.fillRect(x, y, this.scaleVal(this.mySize), h);
            g.setColor(this.myColor2);
            g.fillRect(x + this.scaleVal(this.mySize) + this.scaleVal(2), y, this.scaleVal(this.mySize), h);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MyIcon icon = (MyIcon)((Object)o);
            if (this.getIconWidth() != icon.getIconWidth()) {
                return false;
            }
            if (this.getIconHeight() != icon.getIconHeight()) {
                return false;
            }
            if (!this.myColor1.equals(icon.myColor1)) {
                return false;
            }
            return this.myColor2.equals(icon.myColor2);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myColor1.hashCode();
            result = 31 * result + this.myColor2.hashCode();
            return result;
        }
    }
}

