/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.common.FunctionNamePresentation;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.lang.javascript.ui.FileColor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StackNode
extends SimpleNode {
    private FunctionNamePresentation myFuncName;
    private RuntimeFunctionScope myScope;
    private String myFile;
    private Boolean myIsRootNode;
    private List<StackNode> myChildren;
    private double myStartTime;
    private Double myExecutionTime;
    private String myDisplayName;
    private int myNodeIndex;
    private CodeRange myCodeRange;
    private String myText;
    private boolean myTakesSignificantTimeToExecute;

    public StackNode() {
        this.myChildren = new ArrayList<StackNode>();
        this.myText = "";
        this.myIsRootNode = true;
    }

    private StackNode(@NotNull RuntimeFunctionScope scope, @NotNull StackNode parent) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/trace/execution/stack/StackNode", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/stack/StackNode", "<init>"));
        }
        super((SimpleNode)parent);
        this.myChildren = new ArrayList<StackNode>();
        this.myText = "";
        this.myIsRootNode = false;
        this.myScope = scope;
        this.myCodeRange = this.myScope.getCodeRange();
        this.myFuncName = new FunctionNamePresentation(this.myScope, this.myScope.isProgram(), this.myScope.hasException());
        this.myFile = this.myScope.getFile();
        this.setIcon(FileColor.getIcon((String)this.myFile));
        this.setText(this.getPresentation());
    }

    public StackNode createChild(RuntimeFunctionScope scope) {
        StackNode child = new StackNode(scope, this);
        this.myChildren.add(child);
        return child;
    }

    public RuntimeFunctionScope getScope() {
        return this.myScope;
    }

    public SimpleNode[] getChildren() {
        return this.myChildren.toArray(new SimpleNode[this.myChildren.size()]);
    }

    public String getName() {
        if (this.myDisplayName == null && !this.myIsRootNode.booleanValue()) {
            this.myDisplayName = this.myFuncName.getFunctionName();
        }
        return this.myDisplayName;
    }

    public void startedAt(double time) {
        this.myStartTime = time;
    }

    public void finishedAt(double time) {
        this.myExecutionTime = time - this.myStartTime;
        this.setText(this.getPresentation());
        this.myScope.setExecutionTime(this.myExecutionTime);
    }

    public StackNode getParentStackNode() {
        if (this.myIsRootNode.booleanValue()) {
            return null;
        }
        return (StackNode)this.getParent();
    }

    protected void setText(PresentationData presentation) {
        presentation.clearText();
        this.myText = this.myFuncName.buildFullName(presentation, true, this.myExecutionTime, this.myTakesSignificantTimeToExecute);
    }

    @NotNull
    public String getFile() {
        String string = this.myFile;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/stack/StackNode", "getFile"));
        }
        return string;
    }

    @NotNull
    public CodeRange getCodeRange() {
        CodeRange codeRange = this.myCodeRange;
        if (codeRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/stack/StackNode", "getCodeRange"));
        }
        return codeRange;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        ((StackTree)tree).stackNodeSelected(this);
    }

    public boolean isAlwaysLeaf() {
        return this.myChildren.size() == 0;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public int getNodeIndex() {
        return this.myNodeIndex;
    }

    public void setNodeIndex(int nodeIndex) {
        this.myNodeIndex = nodeIndex;
    }

    public String getText() {
        return this.myText;
    }

    public double getExecutionTime() {
        return this.myExecutionTime != null ? this.myExecutionTime : 0.0;
    }

    public void takesSignificantTimeToExecute() {
        this.myTakesSignificantTimeToExecute = true;
        this.setText(this.getPresentation());
    }

    public int getFunctionId() {
        return this.myScope.getFunctionId();
    }
}

