/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack.actions;

import com.intellij.javascript.trace.execution.code.MappedCodePosition;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.javascript.trace.execution.stack.actions.StackTreeAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class JumpToMappedTraceAction
extends StackTreeAction {
    @Override
    protected void doPerform(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/JumpToMappedTraceAction", "doPerform"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/JumpToMappedTraceAction", "doPerform"));
        }
        tree.stackNodeMappedTraceRequested(selectedNode);
    }

    @Override
    protected void doUpdate(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/JumpToMappedTraceAction", "doUpdate"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/JumpToMappedTraceAction", "doUpdate"));
        }
        if (!tree.getTraceSettingsManager().isSourceMapSupportEnabled()) {
            e.getPresentation().setVisible(false);
            return;
        }
        MappedCodePosition mappedCodePosition = selectedNode.getCodeRange().getMappedCodePosition();
        if (mappedCodePosition == null) {
            e.getPresentation().setVisible(false);
        }
    }
}

