/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack.actions;

import com.intellij.javascript.trace.execution.NodeModuleUtils;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.javascript.trace.execution.stack.actions.StackTreeAction;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.lang.javascript.ui.NodeModuleNamesUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class MuteNodeModuleAction
extends StackTreeAction {
    @Override
    protected void doUpdate(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        TraceProjectSettings.EventFilterState filter;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/MuteNodeModuleAction", "doUpdate"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/MuteNodeModuleAction", "doUpdate"));
        }
        String module = NodeModuleNamesUtil.getModule((String)selectedNode.getFile());
        if (!MuteNodeModuleAction.canBeFiltered(module, filter = tree.getTraceSettingsManager().getActiveFilter())) {
            e.getPresentation().setVisible(false);
        }
    }

    private static boolean canBeFiltered(String module, TraceProjectSettings.EventFilterState filter) {
        return !StringUtil.isEmpty((String)module) && !NodeModuleUtils.containsNodeModulesPattern(filter) && !NodeModuleUtils.containsNodeModulePattern(filter, module);
    }

    @Override
    protected void doPerform(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        TraceProjectSettings.EventFilterState filter;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/MuteNodeModuleAction", "doPerform"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/MuteNodeModuleAction", "doPerform"));
        }
        String module = NodeModuleNamesUtil.getModule((String)selectedNode.getFile());
        if (!MuteNodeModuleAction.canBeFiltered(module, filter = tree.getTraceSettingsManager().getActiveFilter())) {
            return;
        }
        NodeModuleUtils.muteNodeModule(tree.getTraceSettingsManager(), module);
    }
}

