/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRestJavaInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkFile"));
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null && RSUtils.isRestLibAttached(module)) {
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly, module);
            List problemDescriptors = holder.getResults();
            return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFile", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkJavaFile"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkJavaFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkJavaFile"));
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder, module);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkClassInternal"));
        }
        this.checkClass(aClass, holder, module);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder, module);
        }
    }

    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkClass"));
        }
        if (psiClass instanceof PsiAnonymousClass || psiClass instanceof PsiTypeParameter) {
            return;
        }
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (psiMethod.isConstructor()) continue;
            this.checkMethod(psiMethod, holder, module);
        }
        for (PsiMethod psiMethod : psiClass.getFields()) {
            this.checkFields((PsiField)psiMethod, holder, module);
        }
    }

    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkMethod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkMethod"));
        }
    }

    protected void checkFields(@NotNull PsiField field, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkFields"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkFields"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "checkFields"));
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = RSBundle.message("webservices.inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/AbstractRestJavaInspection", "getGroupDisplayName"));
        }
        return string;
    }
}

