/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestResourceMethodInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "checkClass"));
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.ws.rs.Path", (boolean)true) && !RestResourceMethodInspection.hasPublicResourceMethods(psiClass, module)) {
            PsiIdentifier identifier = psiClass.getNameIdentifier();
            holder.registerProblem((PsiElement)(identifier != null ? identifier : psiClass), RSBundle.message("resource.methods.inspection.class.has.no.public.methods", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
        super.checkClass(psiClass, holder, module);
    }

    private static boolean hasPublicResourceMethods(PsiClass psiClass, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "hasPublicResourceMethods"));
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List methods = jamService.getAnnotatedMembersList(psiClass, RSHttpMethod.RS_HTTP_METHOD_JAM_KEY, false, true, false, true);
        for (RSHttpMethod method : methods) {
            if (!method.getPsiElement().getModifierList().hasModifierProperty("public")) continue;
            return true;
        }
        for (RSJamPsiMethodPath path : jamService.getAnnotatedMembersList(psiClass, false, true, false, true, new JamMemberMeta[]{RSJamPsiMethodPath.META})) {
            if (!path.getPsiElement().getModifierList().hasModifierProperty("public")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void checkMethod(@NotNull PsiMethod method, @NotNull ProblemsHolder problemsHolder, @NotNull Module module) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "checkMethod"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "checkMethod"));
        }
        PsiClass c = method.getContainingClass();
        if (c == null) {
            return;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, Arrays.asList("javax.ws.rs.Path", "javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "javax.ws.rs.HEAD"));
        if (annotation != null) {
            RestResourceMethodInspection.checkPublicMethod(method, annotation, problemsHolder);
        }
    }

    private static void checkPublicMethod(@NotNull PsiMethod method, PsiAnnotation annotation, @NotNull ProblemsHolder holder) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "checkPublicMethod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "checkPublicMethod"));
        }
        if (!method.getModifierList().hasModifierProperty("public")) {
            String shortName = "@" + StringUtil.getShortName((String)annotation.getQualifiedName());
            holder.registerProblem((PsiElement)method.getNameIdentifier(), RSBundle.message("resource.methods.inspection.method.must.be.public", shortName), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("resource.methods.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("RestResourceMethodInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/RestResourceMethodInspection", "getShortName"));
        }
        return "RestResourceMethodInspection";
    }
}

