/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.providers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.ws.rest.client.RestClientDataProvider;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.Collection;

public class WsRestClientDataProvider
implements RestClientDataProvider {
    public String[] getAllPaths(Project project) {
        PsiAnnotation[] pathAnnos;
        ArrayListSet paths = new ArrayListSet();
        Collection annos = JavaAnnotationIndex.getInstance().get("Path", project, GlobalSearchScope.projectScope((Project)project));
        for (PsiAnnotation pathAnno : pathAnnos = annos.toArray(new PsiAnnotation[annos.size()])) {
            PsiMethod[] methods;
            String path;
            PsiElement parent = pathAnno.getParent();
            if (parent != null) {
                parent = parent.getParent();
            }
            if (!RSUtils.isRootResourceClass(parent) || (path = (String)AnnotationModelUtil.getStringValue((PsiAnnotation)pathAnno, (String)"value", (String)"/").getValue()) == null || parent == null) continue;
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            paths.add(path);
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            for (PsiMethod method : methods = ((PsiClass)parent).getAllMethods()) {
                String value;
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"javax.ws.rs.Path", (boolean)true) || (value = (String)AnnotationModelUtil.getStringValue((PsiAnnotation)method.getModifierList().findAnnotation("javax.ws.rs.Path"), (String)"value", (String)"").getValue()) == null || value.trim().length() == 0) continue;
                value = StringUtil.trimStart((String)value, (String)"/");
                paths.add(path + value);
            }
        }
        return ArrayUtil.toStringArray((Collection)paths);
    }

    public String[] getAllMimeTypes(Project project) {
        return RSUtils.getAllMimes(project);
    }
}

