/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.header;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.ClassReferenceParser;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.util.OsgiPsiUtil;

public class BundleActivatorParser
extends ClassReferenceParser {
    public static final HeaderParser INSTANCE = new BundleActivatorParser();

    private BundleActivatorParser() {
    }

    protected boolean checkClass(@NotNull HeaderValuePart valuePart, @NotNull PsiClass aClass, @NotNull AnnotationHolder holder) {
        if (valuePart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePart", "org/osmorc/manifest/lang/header/BundleActivatorParser", "checkClass"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/osmorc/manifest/lang/header/BundleActivatorParser", "checkClass"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/osmorc/manifest/lang/header/BundleActivatorParser", "checkClass"));
        }
        PsiClass activatorClass = OsgiPsiUtil.getActivatorClass(valuePart.getProject());
        if (activatorClass != null && !aClass.isInheritor(activatorClass, true)) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), OsmorcBundle.message("manifest.activator.class.invalid", new Object[0]));
            return true;
        }
        return false;
    }
}

