/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.LibraryBundlingEditorComponent;

public class LibraryBundlingEditor
implements SearchableConfigurable,
Configurable.NoScroll {
    private LibraryBundlingEditorComponent myComponent;

    @Nls
    public String getDisplayName() {
        return "Library Bundling";
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.settings.project.osgi.library.bundling" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/LibraryBundlingEditor", "getHelpTopic"));
        }
        return "reference.settings.project.osgi.library.bundling";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/LibraryBundlingEditor", "getId"));
        }
        return string;
    }

    public JComponent createComponent() {
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        this.myComponent = new LibraryBundlingEditorComponent(project);
        return this.myComponent.getMainPanel();
    }

    public boolean isModified() {
        return this.myComponent != null && this.myComponent.isModified(ApplicationSettings.getInstance());
    }

    public void apply() throws ConfigurationException {
        this.myComponent.applyTo(ApplicationSettings.getInstance());
    }

    public void reset() {
        this.myComponent.resetTo(ApplicationSettings.getInstance());
    }

    public void disposeUIResources() {
        if (this.myComponent != null) {
            this.myComponent.dispose();
            this.myComponent = null;
        }
    }
}

