/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.settings.ProjectSettings;
import org.osmorc.settings.ProjectSettingsEditorComponent;

public class ProjectSettingsEditor
implements SearchableConfigurable {
    private final Project myProject;
    private ProjectSettingsEditorComponent component;

    public ProjectSettingsEditor(Project project) {
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return "OSGi Project Defaults";
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.settings.project.osgi.project.settings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/ProjectSettingsEditor", "getHelpTopic"));
        }
        return "reference.settings.project.osgi.project.settings";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/ProjectSettingsEditor", "getId"));
        }
        return string;
    }

    public JComponent createComponent() {
        this.component = new ProjectSettingsEditorComponent(this.myProject);
        return this.component.getMainPanel();
    }

    public void disposeUIResources() {
        this.component.dispose();
        this.component = null;
    }

    public boolean isModified() {
        return this.component != null && this.component.isModified();
    }

    public void apply() throws ConfigurationException {
        this.component.applyTo(ProjectSettings.getInstance(this.myProject));
    }

    public void reset() {
        this.component.resetTo(ProjectSettings.getInstance(this.myProject));
    }
}

