/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class CopyServerPathsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Deployable server = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(e.getDataContext());
        ServerTreeNode[] nodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(e.getDataContext());
        if (server == null || nodes == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyServerPathsAction.getPaths(server, nodes)));
    }

    private static String getPaths(Deployable server, ServerTreeNode[] nodes) {
        StringBuilder buf = new StringBuilder(nodes.length * 64);
        boolean first = true;
        for (ServerTreeNode node : nodes) {
            if (first) {
                first = false;
            } else {
                buf.append("\n");
            }
            buf.append(server.getPresentablePath(node.getPath()));
        }
        return buf.toString();
    }

    public void update(AnActionEvent event) {
        ServerTreeNode[] nodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(event.getDataContext());
        Presentation presentation = event.getPresentation();
        boolean enabled = nodes != null && nodes.length > 0;
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
        presentation.setText(nodes != null && nodes.length == 1 ? IdeBundle.message((String)"action.copy.path", (Object[])new Object[0]) : IdeBundle.message((String)"action.copy.paths", (Object[])new Object[0]));
    }
}

