/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.util.text.StringKt;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.OldStorageCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a$\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0005\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0000\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0000\u001a \u0010\u0015\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\r\u001a.\u0010\u0015\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u001a\u001c\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"EMPTY_PASSWORD_PREFIX", "", "copyServerCredentials", "", "from", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "to", "createAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "server", "isPasswordMemoryOnly", "", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "getCredentialsAndMemoryOnlyStatus", "Lkotlin/Pair;", "getRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "patchCredentialsAfterReading", "credentials", "patchCredentialsBeforeSaving", "saveCredentials", "userName", "password", "syncWithPasswordSafe", "servers", "", "provider", "Lcom/jetbrains/plugins/webDeployment/config/OldStorageCredentialProvider;", "webDeployment"})
@JvmName(name="WebDeploymentCredentialHelper")
public final class WebDeploymentCredentialHelper {
    @NotNull
    public static final String EMPTY_PASSWORD_PREFIX = "IntelliJ deployment empty password";

    @JvmOverloads
    public static final void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password, boolean isPasswordMemoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        WebDeploymentCredentialHelper.saveCredentials(server, isPasswordMemoryOnly, new Credentials(StringKt.nullize((String)userName, (boolean)true), password));
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void saveCredentials$default(WebServerConfig webServerConfig, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        WebDeploymentCredentialHelper.saveCredentials(webServerConfig, string, string2, bl);
    }

    @JvmOverloads
    public static final void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password) {
        WebDeploymentCredentialHelper.saveCredentials$default(server, userName, password, false, 8, null);
    }

    public static final void saveCredentials(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly, @Nullable Credentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        PasswordSafe.getInstance().set(attributes, WebDeploymentCredentialHelper.patchCredentialsBeforeSaving(credentials));
    }

    @Nullable
    public static final Credentials getCredentials(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        Credentials credentials = PasswordSafe.getInstance().get(attributes);
        return WebDeploymentCredentialHelper.patchCredentialsAfterReading(credentials);
    }

    @NotNull
    public static final Pair<Credentials, Boolean> getCredentialsAndMemoryOnlyStatus(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly);
        Credentials credentials = PasswordSafe.getInstance().get(attributes);
        boolean memoryOnly = credentials == null ? true : PasswordSafe.getInstance().isPasswordStoredOnlyInMemory(attributes, credentials);
        return new Pair((Object)WebDeploymentCredentialHelper.patchCredentialsAfterReading(credentials), (Object)memoryOnly);
    }

    public static final void syncWithPasswordSafe(@NotNull List<? extends WebServerConfig> servers, @NotNull OldStorageCredentialProvider provider) {
        Intrinsics.checkParameterIsNotNull(servers, (String)"servers");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        for (WebServerConfig webServerConfig : servers) {
            Credentials credentials;
            String password = StringKt.nullize$default((String)(webServerConfig.getFileTransferConfig().isUseKeyPair() ? provider.getPassphrase(webServerConfig) : provider.getPassword(webServerConfig)), (boolean)false, (int)1, null);
            String userName = StringKt.nullize$default((String)provider.getUser(webServerConfig), (boolean)false, (int)1, null);
            if (userName == null && password == null || (credentials = WebDeploymentCredentialHelper.getCredentials(webServerConfig, false)) != null && (credentials.getPasswordAsString() != null || password == null)) continue;
            WebDeploymentCredentialHelper.saveCredentials(webServerConfig, false, new Credentials(userName, password));
        }
    }

    private static final CredentialAttributes createAttributes(WebServerConfig server, boolean isPasswordMemoryOnly) {
        return new CredentialAttributes(CredentialAttributesKt.SERVICE_NAME_PREFIX + " Deployment \u2014 " + server.getId(), null, null, isPasswordMemoryOnly, 6, null);
    }

    @NotNull
    public static final RemoteCredentials getRemoteCredentials(@NotNull WebServerConfig server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        RemoteCredentialsHolder remoteCredentials = new RemoteCredentialsHolder();
        Deployable deployable = Deployable.create(server);
        deployable.copyToCredentials((MutableRemoteCredentials)remoteCredentials);
        return (RemoteCredentials)remoteCredentials;
    }

    public static final void copyServerCredentials(@NotNull WebServerConfig from, @NotNull WebServerConfig to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(from, false);
        Credentials credentials = passwordSafe.get(attributes);
        if (!(credentials == null || StringUtil.isEmptyOrSpaces((String)credentials.getUserName()) && StringUtil.isEmptyOrSpaces((String)credentials.getPasswordAsString()))) {
            boolean isMemoryOnly = passwordSafe.isPasswordStoredOnlyInMemory(attributes, credentials);
            CredentialAttributes cloneAttributes = WebDeploymentCredentialHelper.createAttributes(to, false);
            passwordSafe.set(cloneAttributes, credentials, isMemoryOnly);
        }
    }

    @Nullable
    public static final Credentials patchCredentialsBeforeSaving(@Nullable Credentials credentials) {
        CharSequence charSequence;
        if (credentials == null) {
            return null;
        }
        String password = credentials.getPasswordAsString();
        if (password != null && ((charSequence = (CharSequence)password).length() == 0 || StringsKt.startsWith$default((String)password, (String)EMPTY_PASSWORD_PREFIX, (boolean)false, (int)2, null))) {
            return new Credentials(credentials.getUserName(), EMPTY_PASSWORD_PREFIX + password);
        }
        return credentials;
    }

    @Nullable
    public static final Credentials patchCredentialsAfterReading(@Nullable Credentials credentials) {
        Credentials credentials2;
        if (credentials == null) {
            return null;
        }
        String password = credentials.getPasswordAsString();
        if (password == null) {
            return credentials;
        }
        CharSequence charSequence = password;
        if (charSequence.length() == 0) {
            return new Credentials(credentials.getUserName(), (String)null);
        }
        if (!StringsKt.startsWith$default((String)password, (String)EMPTY_PASSWORD_PREFIX, (boolean)false, (int)2, null)) {
            return credentials;
        }
        charSequence = password;
        int n = EMPTY_PASSWORD_PREFIX.length();
        String string = credentials.getUserName();
        Credentials credentials3 = credentials2;
        Credentials credentials4 = credentials2;
        String string2 = ((String)charSequence).substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String string3 = string2;
        credentials3(string, string3);
        return credentials4;
    }
}

