/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config.sockets;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import com.jcraft.jsch.SocketFactory;
import com.jetbrains.plugins.webDeployment.config.sockets.DeploymentSocketUtils;
import com.jetbrains.plugins.webDeployment.config.sockets.ItemHolder;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.jetbrains.annotations.Nullable;

class MySftpSocketFactory
implements SocketFactory {
    private static final Logger LOG = Logger.getInstance((String)MySftpSocketFactory.class.getName());
    private final ItemHolder<Socket> mySockets;

    MySftpSocketFactory(@Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger) {
        if (disconnectTrigger != null) {
            this.mySockets = ItemHolder.createDefaultSocketHolder();
            disconnectTrigger.addListener(this.mySockets);
        } else {
            this.mySockets = null;
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket socket;
        InetAddress inetAddress = InetAddress.getByName(host);
        InetAddress properAddress = DeploymentSocketUtils.getProperAddressIfNeeded(inetAddress);
        if (properAddress != null) {
            LOG.debug("Patched sftp socket for " + properAddress);
            socket = MySftpSocketFactory.createDefaultSocket(properAddress, port);
        } else {
            LOG.debug("Default sftp socket for " + host);
            socket = MySftpSocketFactory.createDefaultSocket(host, port);
        }
        if (this.mySockets != null) {
            this.mySockets.add(socket);
        }
        return socket;
    }

    private static Socket createDefaultSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    private static Socket createDefaultSocket(InetAddress address, int port) throws IOException {
        return new Socket(address, port);
    }

    public InputStream getInputStream(Socket socket) throws IOException {
        return socket.getInputStream();
    }

    public OutputStream getOutputStream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    public boolean equals(Object obj) {
        return obj instanceof MySftpSocketFactory;
    }

    public int hashCode() {
        return 0;
    }
}

