/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.OptionsDialog;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverwriteLocalWarningDialog
extends OptionsDialog {
    private final PublishConfig myConfig;
    @Nullable
    private final PublishConfig myOriginalConfig;

    public static OverwriteLocalWarningDialog createInstance(@NotNull ConnectionOwner connectionOwner, @NotNull PublishConfig config, String serverName, @NotNull PublishConfig originalConfig) {
        Project project;
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/OverwriteLocalWarningDialog", "createInstance"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/ui/OverwriteLocalWarningDialog", "createInstance"));
        }
        if (originalConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalConfig", "com/jetbrains/plugins/webDeployment/ui/OverwriteLocalWarningDialog", "createInstance"));
        }
        Component component = connectionOwner.getComponentForDialogCreation();
        OverwriteLocalWarningDialog dialog = component != null ? new OverwriteLocalWarningDialog(config, component, originalConfig) : ((project = connectionOwner.getProjectForDialogCreation()) != null ? new OverwriteLocalWarningDialog(project) : new OverwriteLocalWarningDialog(config, originalConfig));
        dialog.init(serverName);
        return dialog;
    }

    private OverwriteLocalWarningDialog(PublishConfig config, @Nullable PublishConfig originalConfig) {
        super((Project)null, false);
        this.myConfig = config;
        this.myOriginalConfig = originalConfig;
    }

    private OverwriteLocalWarningDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/OverwriteLocalWarningDialog", "<init>"));
        }
        super(project, false);
        this.myConfig = PublishConfig.getInstance(project);
        this.myOriginalConfig = null;
    }

    private OverwriteLocalWarningDialog(@NotNull PublishConfig config, Component parent, @Nullable PublishConfig originalConfig) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/ui/OverwriteLocalWarningDialog", "<init>"));
        }
        super(parent, false);
        this.myConfig = config;
        this.myOriginalConfig = originalConfig;
    }

    private void init(String serverName) {
        this.setTitle(WDBundle.message("overwrite.local.dialog.title", serverName));
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        this.setOKButtonText(CommonBundle.getContinueButtonText());
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteLocalWarningDialog", "createActions"));
        }
        return actionArray;
    }

    public boolean isToBeShown() {
        return this.myConfig.isPromptOnLocalOverwrite();
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        this.myConfig.setPromptOnLocalOverwrite(value);
        if (this.myOriginalConfig != null) {
            this.myOriginalConfig.setPromptOnLocalOverwrite(value);
        }
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return false;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(WDBundle.message("overwrite.local.dialog.text", new Object[0]));
        label.setIconTextGap(10);
        label.setIcon(Messages.getWarningIcon());
        panel.add((Component)label, "Center");
        panel.add(Box.createVerticalStrut(10), "South");
        return panel;
    }
}

