/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;

public class OverwriteRemoteWarningDialog
extends DialogWrapper {
    private String myFilePath;
    private Action myOverwriteAction;
    private Action myMergeAction;
    private Action mySkipAction;
    private String myServerName;
    private static final int OVERWRITE_EXIT_CODE = 3;
    private static final int MERGE_EXIT_CODE = 4;
    private static final int SKIP_EXIT_CODE = 5;
    private boolean myProvideDoNotAsk;
    private boolean myRemember;

    public static OverwriteRemoteWarningDialog createInstance(ConnectionOwner connectionOwner, FileObject file, Deployable server, boolean provideDoNotAsk) {
        Component component = connectionOwner.getComponentForDialogCreation();
        OverwriteRemoteWarningDialog dialog = component != null ? new OverwriteRemoteWarningDialog(component) : new OverwriteRemoteWarningDialog(connectionOwner.getProjectForDialogCreation());
        dialog.init(file, server, provideDoNotAsk);
        return dialog;
    }

    private OverwriteRemoteWarningDialog(Project project) {
        super(project, true);
    }

    private OverwriteRemoteWarningDialog(@NotNull Component parentComponent) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "<init>"));
        }
        super(parentComponent, true);
    }

    private void init(FileObject file, Deployable server, boolean provideDoNotAsk) {
        this.myProvideDoNotAsk = provideDoNotAsk;
        this.setTitle(WDBundle.message("overwrite.remote.dialog.title", server.getName()));
        this.myServerName = server.getName();
        this.myFilePath = server.getPresentablePath(file);
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getName().getBaseName());
        this.myMergeAction = fileType.isBinary() || fileType.isReadOnly() ? null : new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.merge.action.name", new Object[0]), 4);
        this.myOverwriteAction = new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.overwrite.action.name", new Object[0]), 3);
        this.mySkipAction = new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.skip.action.name", new Object[0]), 5);
        this.init();
    }

    public void setSkipActionTitle(String title) {
        this.mySkipAction.putValue("Name", title);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(WDBundle.message(this.myMergeAction != null ? "overwrite.remote.dialog.text" : "overwrite.remote.dialog.text.binary", this.myFilePath, this.myServerName));
        label.setIconTextGap(10);
        label.setIcon(Messages.getWarningIcon());
        panel.add((Component)label, "Center");
        if (this.myProvideDoNotAsk) {
            JPanel southPanel = new JPanel(new BorderLayout());
            final JCheckBox checkBox = new JCheckBox();
            checkBox.setText(WDBundle.message("remember.for.this.upload.do.not.ask.again", new Object[0]));
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    OverwriteRemoteWarningDialog.this.myRemember = checkBox.isSelected();
                }
            });
            southPanel.add((Component)checkBox, "Center");
            southPanel.add(Box.createVerticalStrut(10), "North");
            panel.add((Component)southPanel, "South");
        } else {
            panel.add(Box.createVerticalStrut(10), "South");
        }
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myMergeAction != null) {
            Action[] actionArray = new Action[]{this.myOverwriteAction, this.myMergeAction, this.mySkipAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myOverwriteAction, this.mySkipAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "createActions"));
        }
        return actionArray;
    }

    @NotNull
    public OverwriteOption getResult() {
        int code = this.getExitCode();
        switch (code) {
            case 3: {
                OverwriteOption overwriteOption = OverwriteOption.OVERWRITE;
                if (overwriteOption == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "getResult"));
                }
                return overwriteOption;
            }
            case 4: {
                OverwriteOption overwriteOption = OverwriteOption.MERGE;
                if (overwriteOption == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "getResult"));
                }
                return overwriteOption;
            }
            case 5: {
                OverwriteOption overwriteOption = OverwriteOption.SKIP;
                if (overwriteOption == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "getResult"));
                }
                return overwriteOption;
            }
            case 1: {
                OverwriteOption overwriteOption = OverwriteOption.SKIP;
                if (overwriteOption == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "getResult"));
                }
                return overwriteOption;
            }
        }
        throw new IllegalStateException("Unexpected code " + code);
    }

    public boolean isRememberForUpload() {
        return this.myRemember && this.getExitCode() != 1;
    }

    public static enum OverwriteOption {
        SKIP,
        MERGE,
        OVERWRITE;

    }
}

