/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.MessageTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MoveCopyPasteSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerTreeBuilder
extends AbstractTreeBuilder {
    private static final Logger LOG = Logger.getInstance((String)WebServerTreeBuilder.class.getName());
    private static final Comparator<NodeDescriptor> COMPARATOR = (o1, o2) -> {
        if (o1 instanceof MessageTreeNode) {
            return o2 instanceof MessageTreeNode ? ((MessageTreeNode)((Object)o1)).getMessage().compareTo(((MessageTreeNode)((Object)o2)).getMessage()) : -1;
        }
        if (o2 instanceof MessageTreeNode) {
            return 1;
        }
        ServerTreeNode n1 = (ServerTreeNode)((Object)o1);
        ServerTreeNode n2 = (ServerTreeNode)((Object)o2);
        if (n1.isDirectory() && !n2.isDirectory()) {
            return -1;
        }
        if (!n1.isDirectory() && n2.isDirectory()) {
            return 1;
        }
        return n1.getFileName().compareToIgnoreCase(n2.getFileName());
    };
    public static final int UPDATE_NODES_DELAY_MS = 100;
    private final Alarm myUpdateAlarm = new Alarm((Disposable)this);

    public static WebServerTreeBuilder createInstance(@NotNull ServerTreeNode root, @NotNull JTree tree) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder", "createInstance"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder", "createInstance"));
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode((Object)root));
        tree.setModel(treeModel);
        tree.getSelectionModel().setSelectionMode(4);
        return new WebServerTreeBuilder(tree, treeModel, (AbstractTreeStructure)new SimpleTreeStructure.Impl(root){

            public boolean isToBuildChildrenInBackground(Object element) {
                return true;
            }

            public boolean isAlwaysLeaf(Object element) {
                if (element instanceof ServerTreeNode) {
                    return !((ServerTreeNode)((Object)element)).isDirectory();
                }
                LOG.assertTrue(element instanceof MessageTreeNode);
                return true;
            }
        });
    }

    public WebServerTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure) {
        super(tree, treeModel, treeStructure, COMPARATOR);
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)new MoveCopyPasteSupport.RemoteHostCopyPasteListener(this.getUpdater(), tree), (Disposable)this);
        this.myUpdateAlarm.setActivationComponent((JComponent)tree);
    }

    protected void runBackgroundLoading(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder", "runBackgroundLoading"));
        }
        if (this.isDisposed()) {
            return;
        }
        runnable.run();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof MessageTreeNode) {
            return true;
        }
        if (nodeDescriptor instanceof ServerTreeNode) {
            return !((ServerTreeNode)nodeDescriptor).isDirectory() || ((ServerTreeNode)nodeDescriptor).isRoot();
        }
        return false;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        if (descriptor instanceof ServerTreeNode) {
            return ((ServerTreeNode)descriptor).isDirectory();
        }
        LOG.assertTrue(descriptor instanceof MessageTreeNode);
        return false;
    }

    public void refreshSubtree(Collection<WebServerConfig.RemotePath> roots, boolean resync, boolean cleanTreeNodesCache, WebServerConfig.RemotePath selectAfterRefresh) {
        if (this.isDisposed()) {
            return;
        }
        Runnable r = () -> {
            if (this.isDisposed()) {
                return;
            }
            if (cleanTreeNodesCache || resync) {
                try {
                    ServerTreeNode root = this.getRoot();
                    if (root == null) {
                        return;
                    }
                    RemoteConnection connection = root.getOpenRemoteConnection();
                    if (connection == null) {
                        return;
                    }
                    List expandedElements = this.getUi().getExpandedElements();
                    connection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> {
                        for (WebServerConfig.RemotePath root1 : roots) {
                            ProgressManager.checkCanceled();
                            ServerTreeNode node = this.findNode(root1);
                            if (node == null) continue;
                            if (resync && node.getFileObject() != null) {
                                node.getFileObject().refresh();
                            }
                            if (!cleanTreeNodesCache) continue;
                            node.reloadNecessaryDescendants(true, true, expandedElements);
                        }
                    }), null);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                }
            }
            ActionCallback callback = null;
            for (WebServerConfig.RemotePath root : roots) {
                ProgressManager.checkCanceled();
                ServerTreeNode rootNode = this.getRoot();
                if (rootNode == null) {
                    return;
                }
                ServerTreeNode toUpdate = rootNode.createForSelection(root);
                if (toUpdate == null) {
                    return;
                }
                if (toUpdate.getParent() != null) {
                    toUpdate = (ServerTreeNode)toUpdate.getParent();
                }
                callback = this.queueUpdateFrom((Object)toUpdate, true);
            }
            if (selectAfterRefresh != null) {
                if (callback != null) {
                    callback.doWhenDone(() -> this.selectPath(selectAfterRefresh));
                } else if (ApplicationManager.getApplication().isDispatchThread()) {
                    this.selectPath(selectAfterRefresh);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> this.selectPath(selectAfterRefresh));
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(r);
        } else {
            r.run();
        }
    }

    @Nullable
    public ServerTreeNode findNode(WebServerConfig.RemotePath path) {
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return null;
        }
        Object node = this.findNodeByElement((Object)root.createForSelection(path));
        return node instanceof DefaultMutableTreeNode ? (ServerTreeNode)((Object)((DefaultMutableTreeNode)node).getUserObject()) : null;
    }

    public void selectPath(WebServerConfig.RemotePath path) {
        if (this.isDisposed()) {
            return;
        }
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        ServerTreeNode selection = root.createForSelection(path);
        if (selection != null) {
            root.reloadNecessaryDescendantsAndUpdate(false, false, Collections.singletonList(selection), () -> ApplicationManager.getApplication().invokeLater(() -> this.select((Object)selection)));
        }
    }

    @Nullable
    public ServerTreeNode getRoot() {
        AbstractTreeStructure structure = this.getTreeStructure();
        return structure == null ? null : (ServerTreeNode)((Object)structure.getRootElement());
    }

    public void refreshWhenIdle(final ServerTreeNode node) {
        Runnable updater = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractTreeUi ui = WebServerTreeBuilder.this.getUi();
                if (ui == null) {
                    return;
                }
                boolean isIdle = ui.isIdle();
                if (isIdle) {
                    try {
                        WebServerTreeBuilder.this.refreshSubtree(Collections.singletonList(node.getPath()), false, false, null);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    finally {
                        WebServerTreeBuilder.this.myUpdateAlarm.cancelRequest((Runnable)this);
                    }
                } else {
                    WebServerTreeBuilder.this.myUpdateAlarm.addComponentRequest((Runnable)this, 100);
                }
            }
        };
        this.myUpdateAlarm.addComponentRequest(updater, 100);
    }

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
        super.dispose();
    }

    public void refreshRoot() {
        ServerTreeNode root = this.getRoot();
        if (root == null) {
            return;
        }
        root.invalidate();
        root.reloadNecessaryDescendantsAndUpdate(true, true, this.getUi().getExpandedElements(), null);
    }
}

