/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.coffeescript.CsBundle;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptCompiledForm
extends FrameWrapper {
    private JPanel myContentPanel;
    private JSplitPane mySplitPanel;
    private JPanel leftEditorPanel;
    private JPanel rightEditorPanel;
    private JLabel lblLeftEditor;
    private final PsiFile myCoffeeScriptFile;
    private final PsiFile myJavaScriptFile;

    protected CoffeeScriptCompiledForm(Project project, Editor editor, @NotNull PsiFile coffeeScriptFile, @NotNull PsiFile javaScriptFile) {
        if (coffeeScriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coffeeScriptFile", "org/coffeescript/compiler/CoffeeScriptCompiledForm", "<init>"));
        }
        if (javaScriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaScriptFile", "org/coffeescript/compiler/CoffeeScriptCompiledForm", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        JBDimension size = JBUI.size((int)800, (int)600);
        this.setSize((Dimension)size);
        if (editor != null) {
            Rectangle screen = ScreenUtil.getScreenRectangle((Component)editor.getContentComponent());
            int x = (screen.width - size.width) / 2;
            int y = (screen.height - size.height) / 2;
            Point location = new Point(x, y);
            this.setLocation(location);
        }
        this.myCoffeeScriptFile = coffeeScriptFile;
        this.myJavaScriptFile = javaScriptFile;
        this.setTitle(CsBundle.message("compile.title", new Object[0]));
        this.lblLeftEditor.setText(CsBundle.message("compile.original.file.title", new Object[0]));
        this.createCenterPanel();
        this.setComponent(this.myContentPanel);
        this.closeOnEsc();
    }

    private static Editor createEditor(@NotNull PsiFile psiFile, @NotNull Project project) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/coffeescript/compiler/CoffeeScriptCompiledForm", "createEditor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/coffeescript/compiler/CoffeeScriptCompiledForm", "createEditor"));
        }
        DocumentImpl document = new DocumentImpl(psiFile.getText().replaceAll("\r", ""));
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor result = editorFactory.createEditor((Document)document, project, psiFile.getFileType(), true);
        EditorSettings editorSettings = result.getSettings();
        editorSettings.setLineMarkerAreaShown(true);
        editorSettings.setLineNumbersShown(true);
        editorSettings.setIndentGuidesShown(true);
        return result;
    }

    protected JComponent createCenterPanel() {
        final Editor leftEditor = CoffeeScriptCompiledForm.createEditor(this.myCoffeeScriptFile, this.myCoffeeScriptFile.getProject());
        final Editor rightEditor = CoffeeScriptCompiledForm.createEditor(this.myJavaScriptFile, this.myCoffeeScriptFile.getProject());
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                EditorFactory.getInstance().releaseEditor(leftEditor);
            }
        });
        this.leftEditorPanel.add(leftEditor.getComponent());
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                EditorFactory.getInstance().releaseEditor(rightEditor);
            }
        });
        this.rightEditorPanel.add(rightEditor.getComponent());
        this.mySplitPanel.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CoffeeScriptCompiledForm.this.mySplitPanel.setDividerLocation(CoffeeScriptCompiledForm.this.mySplitPanel.getWidth() / 2);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        JSplitPane jSplitPane;
        JPanel jPanel3;
        this.myContentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:grow"));
        this.mySplitPanel = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(122);
        jPanel3.add((Component)jSplitPane, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jSplitPane.setLeftComponent(jPanel4);
        this.lblLeftEditor = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/coffeescript/CsBundle").getString("compile.original.file.title"));
        jPanel4.add((Component)jLabel, "North");
        this.leftEditorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jSplitPane.setRightComponent(jPanel5);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/coffeescript/CsBundle").getString("compile.generated.file.title"));
        jPanel5.add((Component)jLabel2, "North");
        this.rightEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

