/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.parser;

import com.intellij.indentation.AbstractIndentParser;
import com.intellij.indentation.OperationParserHelper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import org.coffeescript.CoffeeScriptLiterateLanguage;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoffeeScriptParser
extends AbstractIndentParser
implements OperationParserHelper.BinaryOperationParser,
OperationParserHelper.CustomBinaryOperationParser,
PsiParser {
    private static final IElementType[] BINARY_OPERATIONS_ELEMENT = new IElementType[]{CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.ASSIGN_EXPRESSION};
    private final TokenSet ARRAY_PREFIX = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptTokenTypes.BRACKET_START, CoffeeScriptTokenTypes.BRACE_START, CoffeeScriptTokenTypes.PARENTHESIS_START, CoffeeScriptTokenTypes.EQ, CoffeeScriptTokenTypes.COLON, CoffeeScriptTokenTypes.WHITE_SPACE, CoffeeScriptTokenTypes.COMMA, CoffeeScriptTokenTypes.INTERPOLATION_START, CoffeeScriptTokenTypes.EXIST_EQ}), CoffeeScriptTokenTypes.OPERATION_SIGNS, CoffeeScriptTokenTypes.EQUALITY_OPERATIONS}), (TokenSet)TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptTokenTypes.EXIST}));
    private HashMap<PsiBuilder.Marker, List<List<String>>> myDeclarationStack;
    private List<List<String>> declaredVariables = new ArrayList<List<String>>();

    private void init() {
        this.myIndents = new HashMap();
        this.myNewLines = new HashMap();
        this.myDeclarationStack = new HashMap();
        int offset = this.getCurrentOffset();
        if (offset > 0) {
            String whiteSpaceText = this.myBuilder.getOriginalText().subSequence(0, offset).toString();
            int i = whiteSpaceText.lastIndexOf(10);
            this.myCurrentIndent = i >= 0 ? whiteSpaceText.length() - i - 1 : whiteSpaceText.length();
        }
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        this.parseWithoutBuildingTree(root, builder);
        ASTNode aSTNode = this.myBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/BaseCoffeeScriptParser", "parse"));
        }
        return aSTNode;
    }

    public void parseWithoutBuildingTree(IElementType root, PsiBuilder builder) {
        this.myNewLines = new HashMap();
        this.myIndents = new HashMap();
        this.myBuilder = builder;
        PsiBuilder.Marker rootMarker = this.myBuilder.mark();
        this.init();
        if (!this.myBuilder.eof()) {
            this.parseRoot(root.getLanguage() == CoffeeScriptLiterateLanguage.INSTANCE);
        }
        rootMarker.done(root);
    }

    protected IElementType getIndentElementType() {
        return null;
    }

    protected IElementType getEolElementType() {
        return null;
    }

    protected void parseRoot(IElementType root) {
    }

    protected abstract void parseRoot(boolean var1);

    public PsiBuilder.Marker mark(boolean couldBeRolledBack) {
        PsiBuilder.Marker result = super.mark(couldBeRolledBack);
        if (couldBeRolledBack) {
            this.cloneDeclarationScopes(result);
        }
        return result;
    }

    protected void rollbackTo(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/coffeescript/lang/parser/BaseCoffeeScriptParser", "rollbackTo"));
        }
        this.declaredVariables = (List)this.myDeclarationStack.get((Object)marker);
        this.myNewLine = (Boolean)this.myNewLines.get((Object)marker);
        this.myDeclarationStack.remove((Object)marker);
        super.rollbackTo(marker);
    }

    private void cloneDeclarationScopes(PsiBuilder.Marker marker) {
        ArrayList result = new ArrayList(this.declaredVariables.size());
        for (List<String> scope : this.declaredVariables) {
            ArrayList<String> clonnedScope = new ArrayList<String>(scope.size());
            clonnedScope.addAll(scope);
            result.add(clonnedScope);
        }
        this.myDeclarationStack.put((Object)marker, result);
    }

    protected void startScope() {
        this.declaredVariables.add(new ArrayList());
    }

    protected void endScope() {
        this.declaredVariables.remove(this.declaredVariables.size() - 1);
    }

    protected void addVariableInCurrentScope(@NotNull String variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "org/coffeescript/lang/parser/BaseCoffeeScriptParser", "addVariableInCurrentScope"));
        }
        this.declaredVariables.get(this.declaredVariables.size() - 1).add(variableName);
    }

    protected boolean isInScope(String name) {
        for (List<String> scope : this.declaredVariables) {
            if (!scope.contains(name)) continue;
            return true;
        }
        return false;
    }

    public void advance() {
        do {
            IElementType previousTokenType = this.myBuilder.getTokenType();
            String tokenText = this.myBuilder.getTokenText();
            int tokenLength = tokenText == null ? 0 : tokenText.length();
            int whiteSpaceStart = this.getCurrentOffset() + tokenLength;
            this.myBuilder.advanceLexer();
            int whiteSpaceEnd = this.getCurrentOffset();
            String whiteSpaceText = this.myBuilder.getOriginalText().subSequence(whiteSpaceStart, whiteSpaceEnd).toString();
            this.myNewLine = false;
            int i = whiteSpaceText.lastIndexOf(10);
            if (i < 0) continue;
            if (previousTokenType == CoffeeScriptTokenTypes.SKIP_EOL) {
                i = whiteSpaceText.indexOf(10, i + 1);
            }
            if (i < 0) continue;
            int lastLineBreakPosition = whiteSpaceText.lastIndexOf(10);
            this.myCurrentIndent = whiteSpaceText.length() - lastLineBreakPosition - 1;
            this.myNewLine = true;
        } while (this.myBuilder.getTokenType() == CoffeeScriptTokenTypes.SKIP_EOL);
    }

    protected boolean nextTokenOnNewLine() {
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        boolean result = this.isNewLine();
        marker.rollbackTo();
        return result;
    }

    @NotNull
    protected String getTokenText(int stepAhead) {
        PsiBuilder.Marker marker = this.mark();
        for (int i = 0; i < stepAhead; ++i) {
            this.myBuilder.advanceLexer();
        }
        String result = this.getTokenText();
        marker.rollbackTo();
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/parser/BaseCoffeeScriptParser", "getTokenText"));
        }
        return string;
    }

    protected int getCurrentOffset() {
        return this.myBuilder.getCurrentOffset();
    }

    protected char charAt(int offset) {
        return this.myBuilder.getOriginalText().charAt(offset);
    }

    protected void skipCommaAndTerminator() {
        while (!this.eof() && (this.isComma() || this.isExpressionTerminator())) {
            this.advance();
        }
    }

    protected boolean isExpressionTerminator() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.SEMICOLON);
    }

    protected static boolean isTokenIn(IElementType tokenType, IElementType ... types) {
        if (types != null) {
            for (IElementType type : types) {
                if (tokenType != type) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isCurrentTokenIn(IElementType ... types) {
        IElementType token = this.myBuilder.getTokenType();
        if (token != null) {
            return BaseCoffeeScriptParser.isTokenIn(token, types);
        }
        return false;
    }

    protected boolean isPostfixOperator() {
        return CoffeeScriptTokenTypes.POSTFIX_OPERATORS.contains(this.getTokenType());
    }

    protected boolean isOperationSymbol() {
        return CoffeeScriptTokenTypes.ARITHMETIC_MUL_OPERATORS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.ARITHMETIC_SUM_OPERATORS.contains(this.getTokenType()) && (this.rawLookup(-1) != CoffeeScriptTokenTypes.WHITE_SPACE || this.rawLookup(1) == CoffeeScriptTokenTypes.WHITE_SPACE) || CoffeeScriptTokenTypes.ARITHMETIC_BIT_OPERATORS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.RELATIONAL_OPERATIONS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.EQUALITY_OPERATIONS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.ASSIGNMENT_OPERATIONS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.BIT_AND.contains(this.getTokenType()) || CoffeeScriptTokenTypes.BIT_OR.contains(this.getTokenType()) || CoffeeScriptTokenTypes.BIT_XOR.contains(this.getTokenType()) || CoffeeScriptTokenTypes.LOGIC_AND.contains(this.getTokenType()) || CoffeeScriptTokenTypes.LOGIC_OR.contains(this.getTokenType());
    }

    protected boolean isIf() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.IF, CoffeeScriptTokenTypes.UNLESS);
    }

    protected boolean isPrototype() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.PROTOTYPE);
    }

    protected boolean isIdentifier() {
        return BaseCoffeeScriptParser.isIdentifier(this.getTokenType());
    }

    protected static boolean isIdentifier(@Nullable IElementType tokenType) {
        return BaseCoffeeScriptParser.isTokenIn(tokenType, CoffeeScriptTokenTypes.IDENTIFIER);
    }

    protected boolean isSuper() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.SUPER);
    }

    protected boolean isComma() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA);
    }

    protected boolean isParenthetical() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_START);
    }

    protected boolean isThis() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.THIS);
    }

    protected boolean isShortThis() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.THIS) && this.getTokenText().equals("@");
    }

    protected boolean isSplatSymbol() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.SPLAT);
    }

    protected boolean isSplatOrRange() {
        return this.isSplatSymbol() || this.isCurrentTokenIn(CoffeeScriptTokenTypes.RANGE);
    }

    protected boolean isRangeSymbol() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.RANGE) || this.isSplatSymbol();
    }

    protected boolean isArray() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_START)) {
            IElementType previousElement = this.rawLookup(-1);
            return this.getCurrentOffset() == 0 || CoffeeScriptTokenTypes.OPERATION_SIGNS.contains(previousElement) && !CoffeeScriptTokenTypes.EXIST_OPERATORS.contains(previousElement) || this.ARRAY_PREFIX.contains(previousElement);
        }
        return false;
    }

    protected boolean isIndex() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_START)) {
            return !this.isArray();
        }
        return false;
    }

    protected boolean isAccessor(int indent) {
        if (indent > this.getCurrentIndent()) {
            return false;
        }
        IElementType tokenType = this.getTokenType();
        if (tokenType == CoffeeScriptTokenTypes.DOT) {
            tokenType = this.lookAhead(1);
            String tokenText = this.getTokenText(1);
            if (BaseCoffeeScriptParser.isIdentifier(tokenType) || tokenText.equals("is") || BaseCoffeeScriptParser.isTokenIn(tokenType, CoffeeScriptTokenTypes.BOOL)) {
                return true;
            }
        } else {
            if (this.isPrototype() || this.isIndex()) {
                return true;
            }
            if (this.isExist()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isExist() {
        return (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXIST) || this.getTokenText().equals("?")) && !this.hasSpaceBefore();
    }

    protected boolean hasSpaceBefore() {
        return this.rawLookup(-1) == CoffeeScriptTokenTypes.WHITE_SPACE;
    }

    protected boolean isSimpleAssignable() {
        return this.isIdentifier() || this.isThis();
    }

    protected boolean isThisProperty() {
        return this.isThis() && BaseCoffeeScriptParser.isIdentifier(this.rawLookup(1));
    }

    protected boolean isSwitchEnd() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.CATCH, CoffeeScriptTokenTypes.FINALLY);
    }

    protected boolean isInvocationWithBraces() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_START) && !this.isNewLine() && this.charAt(this.getCurrentOffset() - 1) != ' ';
    }

    protected boolean isString() {
        return this.isString(this.getTokenType());
    }

    protected boolean isString(IElementType tokenType) {
        return BaseCoffeeScriptParser.isTokenIn(tokenType, CoffeeScriptTokenTypes.HEREDOC_START, CoffeeScriptTokenTypes.STRING_LITERAL);
    }

    protected boolean isRegexp() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.HEREGEX_START, CoffeeScriptTokenTypes.HEREGEX_START, CoffeeScriptTokenTypes.REGEX_START);
    }

    protected boolean isWhile() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.WHILE, CoffeeScriptTokenTypes.UNTIL);
    }

    protected boolean isThrow() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.THROW);
    }

    protected boolean isCode() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.FUNCTION, CoffeeScriptTokenTypes.FUNCTION_BIND) || this.isParenthetical();
    }

    protected boolean isReturn() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.RETURN);
    }

    protected boolean isSwitch() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.SWITCH);
    }

    protected boolean isAlphaNumeric() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.NUMBER, CoffeeScriptTokenTypes.STRING_LITERAL) || this.isString();
    }

    protected boolean isLiteral() {
        return this.isAlphaNumeric() || this.isRegexp() || this.isCurrentTokenIn(CoffeeScriptTokenTypes.JAVASCRIPT_LITERAL, CoffeeScriptTokenTypes.BOOL);
    }

    protected boolean isObjAssignable() {
        return this.isIdentifier() || this.isAlphaNumeric() || this.isThisProperty() || this.isString();
    }

    protected boolean isStatement() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.BREAK, CoffeeScriptTokenTypes.DEBUGGER, CoffeeScriptTokenTypes.CONTINUE) || this.isReturn();
    }

    protected boolean isVariable() {
        return this.isIdentifier() && BaseCoffeeScriptParser.isTokenIn(this.lookAhead(1), CoffeeScriptTokenTypes.EQ) && !this.isInScope(this.getTokenText());
    }

    protected boolean isForBody() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.FOR);
    }

    protected boolean isLoop() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.LOOP);
    }

    protected abstract boolean parseExpression();

    protected boolean isRelationSymbol() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXCL)) {
            return CoffeeScriptTokenTypes.RELATIONAL_OPERATIONS.contains(this.lookAhead(1));
        }
        return CoffeeScriptTokenTypes.RELATIONAL_OPERATIONS.contains(this.getTokenType());
    }

    public boolean parseSimpleExpression() {
        return this.parseExpression();
    }

    public TokenSet getWhitespaceTokenSet() {
        return CoffeeScriptTokenTypes.WHITESPACES;
    }

    public TokenSet getPrefixOperators() {
        return CoffeeScriptTokenTypes.PREFIX_OPERATORS;
    }

    public TokenSet getPostfixOperators() {
        return CoffeeScriptTokenTypes.POSTFIX_OPERATORS;
    }

    public TokenSet[] getOperatorsByPriority() {
        return CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY;
    }

    @Nullable
    public IElementType getPostfixExpressionElementType() {
        return CoffeeScriptElementTypes.POSTFIX_EXPRESSION;
    }

    @Nullable
    public IElementType getPrefixExpressionElementType() {
        return CoffeeScriptElementTypes.PREFIX_EXPRESSION;
    }

    public IElementType[] getOperationElementTypes() {
        return BINARY_OPERATIONS_ELEMENT;
    }

    public boolean isBinaryOperator(int level) {
        IElementType tokenType = this.getTokenType();
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXCL) && CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY[level] == CoffeeScriptTokenTypes.RELATIONAL_OPERATIONS) {
            tokenType = this.lookAhead(1);
        }
        return CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY[level].contains(tokenType);
    }

    public void parseBinaryOperator() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXCL)) {
            this.advance();
        }
        this.advance();
    }
}

