/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.chart.model;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.jboss.jbpm.BpmnUtils;
import com.intellij.jboss.jbpm.chart.model.BpmnChartEdge;
import com.intellij.jboss.jbpm.chart.model.BpmnChartEdgeType;
import com.intellij.jboss.jbpm.chart.model.BpmnChartNode;
import com.intellij.jboss.jbpm.chart.model.BpmnChartSource;
import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.BpmnDomModelManager;
import com.intellij.jboss.jbpm.model.ChartDataModelImpl;
import com.intellij.jboss.jbpm.model.ChartSource;
import com.intellij.jboss.jbpm.model.xml.bpmn20.FlowElementExplicitOwner;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TBaseElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TDefinitions;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowNode;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TProcess;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TSequenceFlow;
import com.intellij.jboss.jbpm.model.xml.bpmndc.Bounds;
import com.intellij.jboss.jbpm.model.xml.bpmndc.Point;
import com.intellij.jboss.jbpm.model.xml.bpmndi.BPMNDiagram;
import com.intellij.jboss.jbpm.model.xml.bpmndi.BPMNEdge;
import com.intellij.jboss.jbpm.model.xml.bpmndi.BPMNPlane;
import com.intellij.jboss.jbpm.model.xml.bpmndi.BPMNShape;
import com.intellij.jboss.jbpm.settings.ChartProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnChartDataModel
extends ChartDataModelImpl<TFlowElement, BpmnChartNode, BpmnChartEdge, BpmnChartSource> {
    private final BpmnDomModel domModel;
    private TProcess process;
    private BPMNDiagram diagram;

    public BpmnChartDataModel(Project project, ChartProvider<TFlowElement> provider, @NotNull BpmnChartSource source, DiagramPresentationModel presentationModel) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/jboss/jbpm/chart/model/BpmnChartDataModel", "<init>"));
        }
        super(project, provider, (ChartSource)source);
        PsiFile psiFile = source.getPsiFile();
        assert (psiFile instanceof XmlFile && BpmnDomModelManager.getInstance(project).isBpmnDomModel((XmlFile)psiFile));
        this.domModel = BpmnDomModelManager.getInstance(project).getModel((XmlFile)psiFile);
    }

    @NotNull
    public String getNodeName(DiagramNode<TFlowElement> n) {
        assert (n instanceof BpmnChartNode);
        BpmnChartNode chartNode = (BpmnChartNode)n;
        String value = chartNode.getIdentifyingElement().getName().getStringValue();
        String string = value == null ? "" : value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/chart/model/BpmnChartDataModel", "getNodeName"));
        }
        return string;
    }

    @NotNull
    public BpmnChartEdge createEdge(BpmnChartNode from, BpmnChartNode to) {
        TSequenceFlow sequenceFlow = this.process.addSequenceFlow();
        sequenceFlow.getSourceRef().setValue((Object)from.getIdentifyingElement());
        sequenceFlow.getTargetRef().setValue((Object)to.getIdentifyingElement());
        String fromId = from.getId();
        String toId = to.getId();
        sequenceFlow.getId().setValue((Object)(fromId + "-" + toId));
        BpmnChartEdge chartEdge = (BpmnChartEdge)this.addEdge(new BpmnChartEdge(from, to, sequenceFlow, BpmnChartEdgeType.Flow));
        chartEdge.setLayout(this.createEdgeShape(from.getLayout(), to.getLayout()));
        BpmnChartEdge bpmnChartEdge = chartEdge;
        if (bpmnChartEdge == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/chart/model/BpmnChartDataModel", "createEdge"));
        }
        return bpmnChartEdge;
    }

    @Nullable
    public BpmnChartNode addElement(TFlowElement element) {
        return (BpmnChartNode)this.addNode(new BpmnChartNode((ChartProvider<TFlowElement>)this.getProvider(), element));
    }

    protected void updateDataModel() {
        if (this.domModel == null) {
            return;
        }
        TDefinitions definitions = this.domModel.getDefinitions();
        if (definitions.getProcesses().size() == 0) {
            this.diagram = null;
            this.process = null;
            return;
        }
        this.process = definitions.getProcesses().get(0);
        for (BPMNDiagram bpmnDiagram : definitions.getBPMNDiagrams()) {
            TBaseElement key = (TBaseElement)bpmnDiagram.getBPMNPlane().getBpmnElement().getValue();
            if (!this.process.equals(key)) continue;
            this.diagram = bpmnDiagram;
            break;
        }
        this.processTProcess(this.process, this.diagram);
    }

    private void processTProcess(TProcess process, BPMNDiagram diagram) {
        this.processFlowNodeOwnerRecursively(process);
        for (TSequenceFlow flow : process.getSequenceFlows()) {
            GenericAttributeValue<TBaseElement> sourceRef = flow.getSourceRef();
            GenericAttributeValue<TBaseElement> targetRef = flow.getTargetRef();
            String sourceId = sourceRef.getStringValue();
            String targetId = targetRef.getStringValue();
            BpmnChartNode sourceNode = (BpmnChartNode)this.getNode(sourceId);
            BpmnChartNode targetNode = (BpmnChartNode)this.getNode(targetId);
            if (sourceNode == null || targetNode == null) continue;
            this.addEdge(new BpmnChartEdge(sourceNode, targetNode, flow, BpmnChartEdgeType.Flow));
        }
        if (diagram != null) {
            this.addNodeLayouts();
            this.addEdgeLayouts();
        }
    }

    private void addNodeLayouts() {
        for (BPMNShape bpmnShape : this.diagram.getBPMNPlane().getBPMNShapes()) {
            String id;
            BpmnChartNode node;
            TBaseElement value = (TBaseElement)bpmnShape.getBpmnElement().getValue();
            if (value == null || (node = (BpmnChartNode)this.getNode(id = (String)value.getId().getValue())) == null) continue;
            node.setLayout(bpmnShape);
        }
    }

    private void addEdgeLayouts() {
        for (BPMNEdge edge : this.diagram.getBPMNPlane().getBPMNEdges()) {
            BpmnChartEdge chartEdge;
            String[] parts;
            String bpmnElement = (String)edge.getBpmnElement().getValue();
            if (bpmnElement == null || (parts = bpmnElement.split("-")).length != 2 || (chartEdge = (BpmnChartEdge)this.getEdge(Pair.create((Object)parts[0], (Object)parts[1]))) == null) continue;
            chartEdge.setLayout(edge);
        }
    }

    private void processFlowNodeOwnerRecursively(@NotNull FlowElementExplicitOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/jboss/jbpm/chart/model/BpmnChartDataModel", "processFlowNodeOwnerRecursively"));
        }
        for (TFlowNode node : BpmnUtils.getFlowNodes(owner)) {
            this.addElement(node);
            if (!(node instanceof FlowElementExplicitOwner)) continue;
            this.processFlowNodeOwnerRecursively((FlowElementExplicitOwner)((Object)node));
        }
    }

    public BPMNShape createNodeShape(@NotNull String id, @NotNull ChartLayoutCoordinator.Point centerPoint, @NotNull ChartLayoutCoordinator.Size size) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/jboss/jbpm/chart/model/BpmnChartDataModel", "createNodeShape"));
        }
        if (centerPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "centerPoint", "com/intellij/jboss/jbpm/chart/model/BpmnChartDataModel", "createNodeShape"));
        }
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/jboss/jbpm/chart/model/BpmnChartDataModel", "createNodeShape"));
        }
        this.getDiagram(true);
        BPMNShape bpmnShape = this.diagram.getBPMNPlane().addBPMNShape();
        bpmnShape.getBpmnElement().setStringValue(id);
        Bounds bounds = bpmnShape.getBounds();
        bounds.getX().setValue((Object)(centerPoint.x - size.width / 2.0));
        bounds.getY().setValue((Object)(centerPoint.y - size.height / 2.0));
        bounds.getWidth().setValue((Object)size.width);
        bounds.getHeight().setValue((Object)size.height);
        return bpmnShape;
    }

    public BPMNEdge createEdgeShape(BPMNShape from, BPMNShape to) {
        this.getDiagram(true);
        BPMNEdge bpmnEdge = this.diagram.getBPMNPlane().addBPMNEdge();
        bpmnEdge.getSourceElement().setValue((Object)from.getId().getStringValue());
        bpmnEdge.getTargetElement().setValue((Object)to.getId().getStringValue());
        bpmnEdge.getBpmnElement().setValue((Object)(from.getBpmnElement().getStringValue() + "-" + to.getBpmnElement().getStringValue()));
        Point fromPoint = bpmnEdge.addWaypoint();
        fromPoint.getX().setValue((Object)((Double)from.getBounds().getX().getValue() + (Double)from.getBounds().getWidth().getValue() / 2.0));
        fromPoint.getY().setValue((Object)((Double)from.getBounds().getY().getValue() + (Double)from.getBounds().getHeight().getValue() / 2.0));
        Point toPoint = bpmnEdge.addWaypoint();
        toPoint.getX().setValue((Object)((Double)to.getBounds().getX().getValue() + (Double)to.getBounds().getWidth().getValue() / 2.0));
        toPoint.getY().setValue((Object)((Double)to.getBounds().getY().getValue() + (Double)to.getBounds().getHeight().getValue() / 2.0));
        return bpmnEdge;
    }

    public void dispose() {
    }

    public Pair<String, String> createUniqueNodeIdAndName(String prefix) {
        String idPrefix = prefix.replace(" ", "") + "_";
        String namePrefix = prefix.trim() + " ";
        int index = 1;
        TProcess process = this.getProcess();
        while (BpmnChartDataModel.elementTreeContainsId(process, idPrefix + index)) {
            ++index;
        }
        return Pair.create((Object)(idPrefix + index), (Object)(namePrefix + index));
    }

    private static boolean elementTreeContainsId(TBaseElement element, @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/jboss/jbpm/chart/model/BpmnChartDataModel", "elementTreeContainsId"));
        }
        if (id.equals(element.getId().getStringValue())) {
            return true;
        }
        for (TBaseElement childElement : DomUtil.getChildrenOfType((DomElement)element, TBaseElement.class)) {
            if (!BpmnChartDataModel.elementTreeContainsId(childElement, id)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public TProcess getProcess() {
        return this.process;
    }

    @Nullable
    public BPMNDiagram getDiagram(boolean createIfNotExist) {
        if (this.diagram == null && createIfNotExist) {
            TDefinitions definitions = this.domModel.getDefinitions();
            this.diagram = definitions.addBPMNDiagram();
            BPMNPlane bpmnPlane = this.diagram.addBPMNPlane();
            bpmnPlane.getBpmnElement().setStringValue(this.process.getId().getStringValue());
        }
        return this.diagram;
    }
}

