/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.fileEditor;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.jboss.jpdl.fileEditor.JpdlDesignerComponent;
import com.intellij.jboss.jpdl.resources.messages.JpdlBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpdlDesignerFileEditor
extends PerspectiveFileEditor {
    private JpdlDesignerComponent myComponent;
    private final XmlFile myXmlFile;

    public JpdlDesignerFileEditor(Project project, VirtualFile file) {
        super(project, file);
        PsiFile psiFile = this.getPsiFile();
        assert (psiFile instanceof XmlFile);
        this.myXmlFile = (XmlFile)psiFile;
    }

    @Nullable
    protected DomElement getSelectedDomElement() {
        List<DomElement> selectedDomElements = this.getJpdlDesignerComponent().getSelectedDomElements();
        return selectedDomElements.size() > 0 ? selectedDomElements.get(0) : null;
    }

    protected void setSelectedDomElement(DomElement domElement) {
        this.getJpdlDesignerComponent().setSelectedDomElement(domElement);
    }

    @NotNull
    protected JComponent createCustomComponent() {
        JpdlDesignerComponent jpdlDesignerComponent = this.getJpdlDesignerComponent();
        if (jpdlDesignerComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/fileEditor/JpdlDesignerFileEditor", "createCustomComponent"));
        }
        return jpdlDesignerComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return ((Graph2DView)this.getJpdlDesignerComponent().getBuilder().getGraph().getCurrentView()).getJComponent();
    }

    public void commit() {
    }

    public void reset() {
        this.getJpdlDesignerComponent().getBuilder().queueUpdate();
    }

    @NotNull
    public String getName() {
        String string = JpdlBundle.message("jpdl.file.editor.designer.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/fileEditor/JpdlDesignerFileEditor", "getName"));
        }
        return string;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return GraphViewUtil.createStructureViewBuilder((Overview)this.getJpdlDesignerComponent().getOverview());
    }

    private JpdlDesignerComponent getJpdlDesignerComponent() {
        if (this.myComponent == null) {
            final JpdlDesignerComponent[] graphComponent = new JpdlDesignerComponent[]{null};
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    graphComponent[0] = new JpdlDesignerComponent(JpdlDesignerFileEditor.this.myXmlFile);
                }
            }, JpdlBundle.message("progress.manager.generating.designer.component", new Object[0]), false, this.myXmlFile.getProject());
            this.myComponent = graphComponent[0];
            Disposer.register((Disposable)this, (Disposable)this.myComponent);
        }
        return this.myComponent;
    }
}

