/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.popup;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.ui.popup.JBPopup;
import java.util.ArrayList;
import javax.swing.JList;

class UmlAddNodesCallback
implements Runnable {
    private final DiagramBuilder myBuilder;
    private final JList myList;

    public UmlAddNodesCallback(DiagramBuilder builder, JList list) {
        this.myBuilder = builder;
        this.myList = list;
    }

    @Override
    public void run() {
        JBPopup popup;
        DiagramState state = new DiagramState(this.myBuilder);
        Object[] selected = this.myList.getSelectedValues();
        boolean added = false;
        DiagramDataModel model = this.myBuilder.getDataModel();
        ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>();
        for (Object obj : selected) {
            DiagramNode node = model.addElement(obj);
            if (node == null) continue;
            nodes.add(node);
            added = true;
        }
        boolean updateLayout = this.myBuilder.isPopupMode() && added;
        model.refreshDataModel();
        this.myBuilder.update(false, true);
        if (updateLayout && (popup = this.myBuilder.getPopup()) != null) {
            DiagramUtils.setBestPopupSizeForGraph((JBPopup)popup, (DiagramBuilder)this.myBuilder);
        }
        if (!DiagramConfiguration.getConfiguration().relayoutOnNewElements) {
            state.restoreTo(this.myBuilder);
        }
        if (nodes.size() > 0) {
            this.myBuilder.getGraph().selectAllNodesAndBends(false);
            for (DiagramNode node : nodes) {
                Node n = this.myBuilder.getNode(node);
                if (n == null) continue;
                this.myBuilder.getGraph().setSelected(n, true);
            }
        }
    }
}

