/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.scopes;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.uml.core.actions.scopes.UmlChangeScopeAction;
import com.intellij.uml.utils.UmlBundle;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlScopesActionGroup
extends ActionGroup
implements Toggleable,
DumbAware {
    public static final Comparator<NamedScope> NAMED_SCOPES_COMPARATOR = (scope1, scope2) -> scope1.getName().compareTo(scope2.getName());
    private final DiagramBuilder myBuilder;
    private final DiagramScopeManager myScopeManager;

    public UmlScopesActionGroup(@NotNull DiagramBuilder builder, @NotNull DiagramScopeManager scopeManager) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/uml/core/actions/scopes/UmlScopesActionGroup", "<init>"));
        }
        if (scopeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeManager", "com/intellij/uml/core/actions/scopes/UmlScopesActionGroup", "<init>"));
        }
        super(UmlBundle.message("change.scope.group.text", new Object[0]), true);
        this.myBuilder = builder;
        this.myScopeManager = scopeManager;
        this.getTemplatePresentation().setIcon(AllIcons.General.Filter);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        NamedScope[] scopes = this.myScopeManager.getScopes();
        Arrays.sort(scopes, NAMED_SCOPES_COMPARATOR);
        AnAction[] actions = new AnAction[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            actions[i] = new UmlChangeScopeAction(this.myScopeManager, scopes[i], this.myBuilder);
        }
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/core/actions/scopes/UmlScopesActionGroup", "getChildren"));
        }
        return actions;
    }
}

