/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project;

import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.uml.project.ModuleItem;

public class ModulesUmlDnDProvider
implements DiagramDnDProvider<ModuleItem> {
    public boolean isAcceptedForDnD(Object o, Project project) {
        if (o instanceof Module || o instanceof Library) {
            return true;
        }
        if (o instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)o;
            return ModuleUtil.findModuleForFile((VirtualFile)psiDirectory.getVirtualFile(), (Project)psiDirectory.getProject()) != null;
        }
        return false;
    }

    public ModuleItem[] wrapToModelObject(Object o, Project project) {
        ModuleItem[] moduleItemArray;
        PsiDirectory psiDirectory;
        Module module;
        ModuleItem result = null;
        if (o instanceof Library) {
            result = new ModuleItem((Library)o, project);
        } else if (o instanceof Module) {
            result = new ModuleItem((Module)o);
        } else if (o instanceof PsiDirectory && (module = ModuleUtil.findModuleForFile((VirtualFile)(psiDirectory = (PsiDirectory)o).getVirtualFile(), (Project)psiDirectory.getProject())) != null) {
            result = new ModuleItem(module);
        }
        if (result == null) {
            moduleItemArray = ModuleItem.EMPTY_ARRAY;
        } else {
            ModuleItem[] moduleItemArray2 = new ModuleItem[1];
            moduleItemArray = moduleItemArray2;
            moduleItemArray2[0] = result;
        }
        return moduleItemArray;
    }
}

