/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.spring.initializr.SpringInitializrFormBuilder;
import com.intellij.spring.initializr.SpringInitializrModuleBuilder;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;

class SpringInitializrServiceChooserStep
extends ModuleWizardStep {
    private static final String START_SPRING_URL = "https://start.spring.io";
    private static final String LAST_SERVICE_URL = "spring.initializr.service.url.last";
    private final SpringInitializrModuleBuilder myBuilder;
    private final JBRadioButton defaultRadioButton = new JBRadioButton("Default:", true);
    private final JBRadioButton customRadioButton = new JBRadioButton("Custom:", false);
    private final TextFieldWithStoredHistory myServiceUrl = new TextFieldWithStoredHistory("spring.initializr.service.url.history");
    private final ComponentWithBrowseButton<TextFieldWithStoredHistory> customUrlWithBrowseButton = new ComponentWithBrowseButton((JComponent)this.myServiceUrl, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SpringInitializrServiceChooserStep.this.validate();
                BrowserUtil.browse((String)SpringInitializrServiceChooserStep.this.myServiceUrl.getText());
            }
            catch (ConfigurationException ex) {
                Messages.showErrorDialog((String)ex.getMessage(), (String)"Cannot Open URL");
            }
        }
    });

    SpringInitializrServiceChooserStep(SpringInitializrModuleBuilder builder) {
        this.myBuilder = builder;
        String lastServiceUrl = PropertiesComponent.getInstance().getValue(LAST_SERVICE_URL, START_SPRING_URL);
        if (!lastServiceUrl.equals(START_SPRING_URL)) {
            this.myServiceUrl.setSelectedItem((Object)lastServiceUrl);
            this.defaultRadioButton.setSelected(false);
            this.customRadioButton.setSelected(true);
        } else {
            this.defaultRadioButton.setSelected(true);
        }
        List history = this.myServiceUrl.getHistory();
        history.remove(START_SPRING_URL);
        this.myServiceUrl.setHistory(history);
        this.updateCustomUrl();
    }

    public JComponent getComponent() {
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.defaultRadioButton);
        group.add((AbstractButton)this.customRadioButton);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpringInitializrServiceChooserStep.this.updateCustomUrl();
            }
        };
        this.defaultRadioButton.addActionListener(listener);
        this.customRadioButton.addActionListener(listener);
        SpringInitializrFormBuilder builder = new SpringInitializrFormBuilder();
        builder.addComponent((JComponent)new JBLabel("Choose Initializr Service URL."));
        builder.addVerticalSpacing();
        JPanel defaultPanel = new JPanel(new BorderLayout());
        defaultPanel.add((Component)this.defaultRadioButton, "West");
        HyperlinkLabel label = new HyperlinkLabel(START_SPRING_URL);
        label.setHyperlinkTarget(START_SPRING_URL);
        defaultPanel.add((Component)label, "Center");
        builder.addComponent(defaultPanel);
        JPanel customPanel = new JPanel(new BorderLayout());
        customPanel.add((Component)this.customRadioButton, "West");
        this.customUrlWithBrowseButton.setButtonIcon(AllIcons.Actions.ShowViewer);
        customPanel.add((Component)this.customUrlWithBrowseButton, "Center");
        builder.addComponent(customPanel);
        builder.addVerticalSpacing();
        builder.addTooltip("Make sure your network connection is active before continuing.");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)builder.getPanel(), "North");
        return panel;
    }

    private void updateCustomUrl() {
        boolean custom = this.customRadioButton.isSelected();
        this.myServiceUrl.getTextEditor().setEnabled(custom);
        this.myServiceUrl.getTextEditor().setEditable(custom);
        this.myServiceUrl.setEnabled(custom);
        this.customUrlWithBrowseButton.setButtonEnabled(custom);
    }

    public boolean validate() throws ConfigurationException {
        if (this.defaultRadioButton.isSelected()) {
            return true;
        }
        String serviceUrl = this.myServiceUrl.getText();
        if (serviceUrl.isEmpty()) {
            throw new ConfigurationException("Custom Initializr Service URL must be set");
        }
        if (!serviceUrl.startsWith("http://") && !serviceUrl.startsWith("https://")) {
            throw new ConfigurationException("Invalid Custom Initializr Service URL");
        }
        try {
            new URL(serviceUrl);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid Custom Initializr Service URL");
        }
        return true;
    }

    public void updateDataModel() {
        String newServiceUrl;
        String string = newServiceUrl = this.customRadioButton.isSelected() ? this.myServiceUrl.getText() : START_SPRING_URL;
        if (!Comparing.strEqual((String)this.myBuilder.getServiceUrl(), (String)newServiceUrl)) {
            this.myServiceUrl.addCurrentTextToHistory();
            this.myBuilder.setServiceUrl(newServiceUrl);
            PropertiesComponent.getInstance().setValue(LAST_SERVICE_URL, newServiceUrl);
            this.myBuilder.setOptions(null);
        }
    }
}

