/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaSearchScope
extends AbstractSearchScope {
    private ArrayList elements;
    private String[] containerPaths;
    private String[] relativePaths;
    private boolean[] isPkgPath;
    protected AccessRuleSet[] pathRestrictions;
    private int pathsCount;
    private int threshold;
    private IPath[] enclosingProjectsAndJars;
    public static final AccessRuleSet NOT_ENCLOSED = new AccessRuleSet(null);

    public JavaSearchScope() {
        this(5);
    }

    private JavaSearchScope(int size) {
        this.initialize(size);
    }

    private void addEnclosingProjectOrJar(IPath path) {
        int length = this.enclosingProjectsAndJars.length;
        int i = 0;
        while (i < length) {
            if (this.enclosingProjectsAndJars[i].equals((Object)path)) {
                return;
            }
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[length + 1];
        System.arraycopy(this.enclosingProjectsAndJars, 0, this.enclosingProjectsAndJars, 0, length);
        this.enclosingProjectsAndJars[length] = path;
    }

    public void add(JavaProject project, int includeMask, HashSet visitedProject) throws JavaModelException {
        this.add(project, null, includeMask, visitedProject, null);
    }

    void add(JavaProject javaProject, IPath pathToAdd, int includeMask, HashSet visitedProjects, IClasspathEntry referringEntry) throws JavaModelException {
        IProject project = javaProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        IPath projectPath = project.getFullPath();
        String projectPathString = projectPath.toString();
        this.addEnclosingProjectOrJar(projectPath);
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true, false, false);
        IJavaModel model = javaProject.getJavaModel();
        JavaModelManager.PerProjectInfo perProjectInfo = javaProject.getPerProjectInfo();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            block17: {
                ClasspathEntry cpEntry;
                AccessRuleSet access;
                IClasspathEntry entry;
                block16: {
                    entry = entries[i];
                    access = null;
                    cpEntry = (ClasspathEntry)entry;
                    if (referringEntry == null) break block16;
                    if (!entry.isExported() && entry.getEntryKind() != 3) break block17;
                    cpEntry = cpEntry.combineWith((ClasspathEntry)referringEntry);
                }
                access = cpEntry.getAccessRuleSet();
                block0 : switch (entry.getEntryKind()) {
                    case 1: {
                        IPath path;
                        IClasspathEntry rawEntry = null;
                        if (perProjectInfo != null && perProjectInfo.resolvedPathToRawEntries != null) {
                            rawEntry = (IClasspathEntry)perProjectInfo.resolvedPathToRawEntries.get(entry.getPath());
                        }
                        if (rawEntry == null) break;
                        switch (rawEntry.getEntryKind()) {
                            case 1: 
                            case 4: {
                                if ((includeMask & 2) != 0) {
                                    path = entry.getPath();
                                    if (pathToAdd == null || pathToAdd.equals((Object)path)) {
                                        String pathToString = path.getDevice() == null ? path.toString() : path.toOSString();
                                        this.add("", pathToString, false, access);
                                        this.addEnclosingProjectOrJar(path);
                                        break;
                                    }
                                }
                                break block17;
                            }
                            case 5: {
                                IClasspathContainer container = JavaCore.getClasspathContainer(rawEntry.getPath(), javaProject);
                                if (container == null) break block0;
                                if (container.getKind() == 1 && (includeMask & 2) != 0 || (includeMask & 4) != 0) {
                                    IPath path2 = entry.getPath();
                                    if (pathToAdd == null || pathToAdd.equals((Object)path2)) {
                                        String pathToString = path2.getDevice() == null ? path2.toString() : path2.toOSString();
                                        this.add("", pathToString, false, access);
                                        this.addEnclosingProjectOrJar(path2);
                                    } else {
                                        break;
                                    }
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case 2: {
                        if ((includeMask & 8) == 0) break;
                        IPath path = entry.getPath();
                        if (pathToAdd != null && !pathToAdd.equals((Object)path)) break;
                        this.add((JavaProject)model.getJavaProject(entry.getPath().lastSegment()), null, includeMask, visitedProjects, cpEntry);
                        break;
                    }
                    case 3: {
                        if ((includeMask & 1) == 0) break;
                        IPath path = entry.getPath();
                        if (pathToAdd != null && !pathToAdd.equals((Object)path)) break;
                        this.add(Util.relativePath(path, 1), projectPathString, false, access);
                    }
                }
            }
            ++i;
        }
    }

    public void add(IJavaElement element) throws JavaModelException {
        IPath containerPath = null;
        String containerPathToString = null;
        int includeMask = 7;
        switch (element.getElementType()) {
            case 1: {
                break;
            }
            case 2: {
                this.add((JavaProject)element, null, includeMask, new HashSet(2), null);
                break;
            }
            case 3: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                IPath rootPath = root.getPath();
                containerPath = root.getKind() == 1 ? root.getParent().getPath() : rootPath;
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                IResource rootResource = root.getResource();
                if (rootResource != null && rootResource.isAccessible()) {
                    String relativePath = Util.relativePath(rootResource.getFullPath(), containerPath.segmentCount());
                    this.add(relativePath, containerPathToString, false, null);
                    break;
                }
                this.add("", containerPathToString, false, null);
                break;
            }
            case 4: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getParent();
                if (root.isArchive()) {
                    String relativePath = Util.concatWith(((PackageFragment)element).names, '/');
                    containerPath = root.getPath();
                    containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                    this.add(relativePath, containerPathToString, true, null);
                    break;
                }
                IResource resource = element.getResource();
                if (resource == null || !resource.isAccessible()) break;
                containerPath = root.getKind() == 1 ? root.getParent().getPath() : root.getPath();
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                String relativePath = Util.relativePath(resource.getFullPath(), containerPath.segmentCount());
                this.add(relativePath, containerPathToString, true, null);
                break;
            }
            default: {
                String relativePath;
                IPackageFragmentRoot root;
                if (element instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(element);
                }
                if ((root = (IPackageFragmentRoot)element.getAncestor(3)).getKind() == 1) {
                    containerPath = root.getParent().getPath();
                    relativePath = Util.relativePath(this.getPath(element, false), 1);
                } else {
                    containerPath = root.getPath();
                    relativePath = this.getPath(element, true).toString();
                }
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                this.add(relativePath, containerPathToString, false, null);
            }
        }
        if (containerPath != null) {
            this.addEnclosingProjectOrJar(containerPath);
        }
    }

    private void add(String relativePath, String containerPath, boolean isPackage, AccessRuleSet access) {
        String currentContainerPath;
        String currentRelativePath;
        containerPath = this.normalize(containerPath);
        relativePath = this.normalize(relativePath);
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % this.containerPaths.length;
        while ((currentRelativePath = this.relativePaths[index]) != null && (currentContainerPath = this.containerPaths[index]) != null) {
            if (currentRelativePath.equals(relativePath) && currentContainerPath.equals(containerPath)) {
                return;
            }
            index = (index + 1) % this.relativePaths.length;
        }
        this.relativePaths[index] = relativePath;
        this.containerPaths[index] = containerPath;
        this.isPkgPath[index] = isPackage;
        if (this.pathRestrictions != null) {
            this.pathRestrictions[index] = access;
        } else if (access != null) {
            this.pathRestrictions = new AccessRuleSet[this.relativePaths.length];
            this.pathRestrictions[index] = access;
        }
        if (++this.pathsCount > this.threshold) {
            this.rehash();
        }
    }

    public boolean encloses(String resourcePathString) {
        int separatorIndex = resourcePathString.indexOf("|");
        if (separatorIndex != -1) {
            String relativePath;
            String jarPath = resourcePathString.substring(0, separatorIndex);
            return this.indexOf(jarPath, relativePath = resourcePathString.substring(separatorIndex + 1)) >= 0;
        }
        return this.indexOf(resourcePathString) >= 0;
    }

    private int indexOf(String fullPath) {
        int i = 0;
        int length = this.relativePaths.length;
        while (i < length) {
            String currentRelativePath = this.relativePaths[i];
            if (currentRelativePath != null) {
                String currentFullPath;
                String currentContainerPath = this.containerPaths[i];
                String string = currentFullPath = currentRelativePath.length() == 0 ? currentContainerPath : String.valueOf(currentContainerPath) + '/' + currentRelativePath;
                if (this.encloses(currentFullPath, fullPath, i)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private int indexOf(String containerPath, String relativePath) {
        String currentContainerPath;
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % this.containerPaths.length;
        while ((currentContainerPath = this.containerPaths[index]) != null) {
            String currentRelativePath;
            if (currentContainerPath.equals(containerPath) && this.encloses(currentRelativePath = this.relativePaths[index], relativePath, index)) {
                return index;
            }
            index = (index + 1) % this.relativePaths.length;
        }
        return -1;
    }

    private boolean encloses(String enclosingPath, String path, int index) {
        int enclosingLength;
        int pathLength = (path = this.normalize(path)).length();
        if (pathLength < (enclosingLength = enclosingPath.length())) {
            return false;
        }
        if (enclosingLength == 0) {
            return true;
        }
        if (pathLength == enclosingLength) {
            return path.equals(enclosingPath);
        }
        if (!this.isPkgPath[index]) {
            return path.startsWith(enclosingPath) && path.charAt(enclosingLength) == '/';
        }
        return path.startsWith(enclosingPath) && (enclosingPath.length() == path.lastIndexOf(47) || enclosingPath.length() == path.length());
    }

    public boolean encloses(IJavaElement element) {
        if (this.elements != null) {
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                IJavaElement scopeElement = (IJavaElement)this.elements.get(i);
                IJavaElement searchedElement = element;
                while (searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getParent();
                }
                ++i;
            }
            return false;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
        if (root != null && root.isArchive()) {
            IPath relativePath;
            IPath rootPath = root.getPath();
            String rootPathToString = rootPath.getDevice() == null ? rootPath.toString() : rootPath.toOSString();
            return this.indexOf(rootPathToString, (relativePath = this.getPath(element, true)).toString()) >= 0;
        }
        String fullResourcePathString = this.getPath(element, false).toString();
        return this.indexOf(fullResourcePathString) >= 0;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.enclosingProjectsAndJars;
    }

    private IPath getPath(IJavaElement element, boolean relativeToRoot) {
        switch (element.getElementType()) {
            case 1: {
                return Path.EMPTY;
            }
            case 2: {
                return element.getPath();
            }
            case 3: {
                if (relativeToRoot) {
                    return Path.EMPTY;
                }
                return element.getPath();
            }
            case 4: {
                String relativePath = Util.concatWith(((PackageFragment)element).names, '/');
                return this.getPath(element.getParent(), relativeToRoot).append((IPath)new Path(relativePath));
            }
            case 5: 
            case 6: {
                return this.getPath(element.getParent(), relativeToRoot).append((IPath)new Path(element.getElementName()));
            }
        }
        return this.getPath(element.getParent(), relativeToRoot);
    }

    public AccessRuleSet getAccessRuleSet(String relativePath, String containerPath) {
        int index = this.indexOf(containerPath, relativePath);
        if (index == -1) {
            return NOT_ENCLOSED;
        }
        if (this.pathRestrictions == null) {
            return null;
        }
        return this.pathRestrictions[index];
    }

    protected void initialize(int size) {
        this.pathsCount = 0;
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.relativePaths = new String[extraRoom];
        this.containerPaths = new String[extraRoom];
        this.isPkgPath = new boolean[extraRoom];
        this.pathRestrictions = null;
        this.enclosingProjectsAndJars = new IPath[0];
    }

    private String normalize(String path) {
        int pathLength = path.length();
        int index = pathLength - 1;
        while (index >= 0 && path.charAt(index) == '/') {
            --index;
        }
        if (index != pathLength - 1) {
            return path.substring(0, index + 1);
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processDelta(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                IJavaElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IJavaElementDelta child = children[i];
                    this.processDelta(child);
                    ++i;
                }
                return;
            }
            case 2: {
                IJavaElement element = delta.getElement();
                if (!this.encloses(element)) return;
                if (this.elements != null) {
                    this.elements.remove(element);
                }
                IPath path = null;
                switch (element.getElementType()) {
                    case 2: {
                        path = ((IJavaProject)element).getProject().getFullPath();
                    }
                    case 3: {
                        if (path == null) {
                            path = ((IPackageFragmentRoot)element).getPath();
                        }
                        int toRemove = -1;
                        int i = 0;
                        while (i < this.pathsCount) {
                            if (this.relativePaths[i].equals(path)) {
                                toRemove = i;
                                break;
                            }
                            ++i;
                        }
                        if (toRemove == -1) return;
                        this.relativePaths[toRemove] = null;
                        this.rehash();
                    }
                }
            }
        }
    }

    private void rehash() {
        JavaSearchScope newScope = new JavaSearchScope(this.pathsCount * 2);
        int i = this.relativePaths.length;
        while (--i >= 0) {
            String currentPath = this.relativePaths[i];
            if (currentPath == null) continue;
            newScope.add(currentPath, this.containerPaths[i], this.isPkgPath[i], this.pathRestrictions == null ? null : this.pathRestrictions[i]);
        }
        this.relativePaths = newScope.relativePaths;
        this.containerPaths = newScope.containerPaths;
        this.isPkgPath = newScope.isPkgPath;
        this.pathRestrictions = newScope.pathRestrictions;
        this.threshold = newScope.threshold;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("JavaSearchScope on ");
        if (this.elements != null) {
            result.append("[");
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                JavaElement element = (JavaElement)this.elements.get(i);
                result.append("\n\t");
                result.append(element.toStringWithAncestors());
                ++i;
            }
            result.append("\n]");
        } else if (this.pathsCount == 0) {
            result.append("[empty scope]");
        } else {
            result.append("[");
            int i = 0;
            while (i < this.relativePaths.length) {
                String path = this.relativePaths[i];
                if (path != null) {
                    result.append("\n\t");
                    result.append(this.containerPaths[i]);
                    if (path.length() > 0) {
                        result.append('/');
                        result.append(path);
                    }
                }
                ++i;
            }
            result.append("\n]");
        }
        return result.toString();
    }
}

