/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.vcsUtil.AuthDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;

class HgCommandAuthenticator {
    private GetPasswordRunnable myGetPassword;
    private final boolean myForceAuthorization;
    private final boolean mySilentMode;

    public HgCommandAuthenticator(boolean forceAuthorization, boolean silent) {
        this.myForceAuthorization = forceAuthorization;
        this.mySilentMode = silent;
    }

    public void forgetPassword() {
        if (this.myGetPassword == null) {
            return;
        }
        String url = VirtualFileManager.extractPath((String)this.myGetPassword.getURL());
        PasswordSafe.getInstance().set(HgCommandAuthenticator.createCredentialAttributes(url), null);
    }

    public boolean promptForAuthentication(Project project, @NotNull String proposedLogin, @NotNull String uri, @NotNull String path, @Nullable ModalityState state) {
        if (proposedLogin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proposedLogin", "org/zmlx/hg4idea/execution/HgCommandAuthenticator", "promptForAuthentication"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/zmlx/hg4idea/execution/HgCommandAuthenticator", "promptForAuthentication"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/execution/HgCommandAuthenticator", "promptForAuthentication"));
        }
        GetPasswordRunnable runnable = new GetPasswordRunnable(project, proposedLogin, uri, path, this.myForceAuthorization, this.mySilentMode);
        ApplicationManager.getApplication().invokeAndWait((Runnable)runnable, state == null ? ModalityState.defaultModalityState() : state);
        this.myGetPassword = runnable;
        return runnable.isOk();
    }

    public String getUserName() {
        return this.myGetPassword.getUserName();
    }

    public String getPassword() {
        return this.myGetPassword.getPassword();
    }

    @NotNull
    private static CredentialAttributes createCredentialAttributes(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/zmlx/hg4idea/execution/HgCommandAuthenticator", "createCredentialAttributes"));
        }
        CredentialAttributes credentialAttributes = new CredentialAttributes("IntelliJ Platform HG \u2014 " + url, null);
        if (credentialAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandAuthenticator", "createCredentialAttributes"));
        }
        return credentialAttributes;
    }

    private static class GetPasswordRunnable
    implements Runnable {
        private Credentials myCredentials;
        private final Project myProject;
        @NotNull
        private final String myProposedLogin;
        private boolean ok;
        @NotNull
        private final String myURL;
        private final boolean myForceAuthorization;
        private final boolean mySilent;

        public GetPasswordRunnable(Project project, @NotNull String proposedLogin, @NotNull String uri, @NotNull String path, boolean forceAuthorization, boolean silent) {
            if (proposedLogin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proposedLogin", "org/zmlx/hg4idea/execution/HgCommandAuthenticator$GetPasswordRunnable", "<init>"));
            }
            if (uri == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/zmlx/hg4idea/execution/HgCommandAuthenticator$GetPasswordRunnable", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/execution/HgCommandAuthenticator$GetPasswordRunnable", "<init>"));
            }
            this.ok = false;
            this.myProject = project;
            this.myProposedLogin = proposedLogin;
            this.myURL = uri + path;
            this.myForceAuthorization = forceAuthorization;
            this.mySilent = silent;
        }

        @Override
        public void run() {
            Credentials savedCredentials;
            String password;
            String login;
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            if (vcs == null) {
                return;
            }
            HgGlobalSettings hgGlobalSettings = vcs.getGlobalSettings();
            String rememberedLoginsForUrl = null;
            String url = VirtualFileManager.extractPath((String)this.myURL);
            if (!StringUtil.isEmptyOrSpaces((String)this.myURL)) {
                rememberedLoginsForUrl = hgGlobalSettings.getRememberedUserName(url);
            }
            if (StringUtil.isEmptyOrSpaces((String)(login = this.myProposedLogin))) {
                login = rememberedLoginsForUrl;
            }
            String string = password = (savedCredentials = PasswordSafe.getInstance().get(HgCommandAuthenticator.createCredentialAttributes(url))) == null ? null : savedCredentials.getPasswordAsString();
            if (savedCredentials != null && StringUtil.isEmptyOrSpaces((String)login)) {
                login = savedCredentials.getUserName();
            }
            if (!(this.myForceAuthorization || StringUtil.isEmptyOrSpaces((String)password) || StringUtil.isEmptyOrSpaces((String)login))) {
                this.myCredentials = new Credentials(login, password);
                this.ok = true;
                return;
            }
            if (this.mySilent) {
                this.ok = false;
                return;
            }
            AuthDialog dialog = new AuthDialog(this.myProject, HgVcsMessages.message("hg4idea.dialog.login.password.required", new Object[0]), HgVcsMessages.message("hg4idea.dialog.login.description", this.myURL), login, password, true);
            if (dialog.showAndGet()) {
                Credentials credentials;
                this.ok = true;
                this.myCredentials = credentials = new Credentials(dialog.getUsername(), dialog.getPassword());
                PasswordSafe.getInstance().set(HgCommandAuthenticator.createCredentialAttributes(url), credentials, !dialog.isRememberPassword());
                hgGlobalSettings.addRememberedUrl(url, credentials.getUserName());
            }
        }

        public String getUserName() {
            return this.myCredentials.getUserName();
        }

        public String getPassword() {
            return this.myCredentials == null ? null : this.myCredentials.getPasswordAsString();
        }

        public boolean isOk() {
            return this.ok;
        }

        @NotNull
        public String getURL() {
            String string = this.myURL;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandAuthenticator$GetPasswordRunnable", "getURL"));
            }
            return string;
        }
    }
}

