/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;

public abstract class SassExtension {
    public static final ExtensionPointName<SassExtension> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.sass.extension");
    private static final String SASS_SCRIPT_FUNCTIONS_MODULE = "Sass::Script::Functions";

    @NotNull
    public static Set<String> getAppropriateRubyModules() {
        HashSet appropriateModules = ContainerUtil.newHashSet((Object[])new String[]{SASS_SCRIPT_FUNCTIONS_MODULE});
        for (SassExtension extension : SassExtension.getAllExtensions(null)) {
            appropriateModules.addAll(extension.getRubyModulesWithFunctionExtensions());
        }
        HashSet hashSet = appropriateModules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtension", "getAppropriateRubyModules"));
        }
        return hashSet;
    }

    public abstract String getName();

    @NotNull
    public static Collection<SassExtension> getAllExtensions(@Nullable Module module) {
        LinkedList result = ContainerUtil.newLinkedList();
        for (SassExtension extension : (SassExtension[])EXTENSION_POINT_NAME.getExtensions()) {
            if (module != null && !extension.isAvailableInModule(module)) continue;
            result.add(extension);
        }
        LinkedList linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtension", "getAllExtensions"));
        }
        return linkedList;
    }

    @NotNull
    public static Collection<SassExtensionFunctionInfo> findExtensionFunctionInfos(@NotNull String name, @Nullable PsiElement context, @Nullable Module module) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/sass/extensions/SassExtension", "findExtensionFunctionInfos"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        if (module != null) {
            PsiFile file = context != null ? context.getContainingFile() : null;
            result.addAll(SassRubyIntegrationHelper.getInstance().findExtensionFunctions(name, module.getProject(), CssUtil.getCompletionAndResolvingScopeForModule((Module)module, (PsiFile)file)));
            result.addAll(SassExtension.findCustomFunctions(name, module));
        } else if (context != null) {
            result.addAll(SassRubyIntegrationHelper.getInstance().findExtensionFunctions(name, context.getProject(), CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context)));
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context.getContainingFile());
            if (module != null) {
                result.addAll(SassExtension.findCustomFunctions(name, module));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtension", "findExtensionFunctionInfos"));
        }
        return arrayList;
    }

    protected abstract boolean isAvailableInModule(@NotNull Module var1);

    protected void startActivity(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/SassExtension", "startActivity"));
        }
    }

    protected void stopActivity(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/SassExtension", "stopActivity"));
        }
    }

    @Nullable
    public abstract SassExtensionFunctionInfo findCustomFunctionByName(@NotNull String var1);

    @NotNull
    public abstract Collection<SassExtensionFunctionInfo> getCustomFunctions();

    @NotNull
    public abstract Collection<String> getRubyModulesWithFunctionExtensions();

    public static void fillCompletionResultWithExtensionFunctions(@NotNull PsiElement position, @NotNull CompletionResultSet result) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/sass/extensions/SassExtension", "fillCompletionResultWithExtensionFunctions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/extensions/SassExtension", "fillCompletionResultWithExtensionFunctions"));
        }
        SassRubyIntegrationHelper.getInstance().fillCompletionResultWithExtensionFunctions(result, position.getProject(), CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position));
    }

    @NotNull
    public abstract Collection<? extends VirtualFile> getStylesheetsRoots(@NotNull Module var1);

    @NotNull
    private static Collection<SassExtensionFunctionInfo> findCustomFunctions(@NotNull String name, @NotNull Module module) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/sass/extensions/SassExtension", "findCustomFunctions"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/SassExtension", "findCustomFunctions"));
        }
        name = SASSSCSSLangUtil.normalizeName(name);
        LinkedList result = ContainerUtil.newLinkedList();
        for (SassExtension sassExtension : SassExtension.getAllExtensions(module)) {
            SassExtensionFunctionInfo customFunction = sassExtension.findCustomFunctionByName(name);
            if (customFunction == null) continue;
            result.add(customFunction);
        }
        LinkedList linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtension", "findCustomFunctions"));
        }
        return linkedList;
    }
}

