/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.scss.formatter.ScssRootBlock;

public class SassRootBlock
extends ScssRootBlock {
    protected SassRootBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
        super(_node, settings, maxPropertyLength, extension);
    }

    @Override
    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/sass/formatter/SassRootBlock", "getSpacing"));
        }
        if (!(child1 instanceof CssFormattingModelBuilder.CssFormatterBlock) || !(child2 instanceof CssFormattingModelBuilder.CssFormatterBlock)) {
            return super.getSpacing(child1, child2);
        }
        CssFormattingModelBuilder.CssFormatterBlock formatterBlock1 = (CssFormattingModelBuilder.CssFormatterBlock)child1;
        CssFormattingModelBuilder.CssFormatterBlock formatterBlock2 = (CssFormattingModelBuilder.CssFormatterBlock)child2;
        IElementType blockType2 = formatterBlock2.getNode().getElementType();
        if (formatterBlock2 instanceof CssFormattingModelBuilder.CssPropertyBlock) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)1);
        }
        if (this.myExtension.isComment(blockType2)) {
            return CssUtil.isHackComment((String)formatterBlock2.getNode().getText()) ? Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0) : Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)1);
        }
        if (formatterBlock1 instanceof CssFormattingModelBuilder.CssPropertyBlock && formatterBlock2 instanceof CssFormattingModelBuilder.CssRulesetBlock) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)1);
        }
        return super.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (newChildIndex != 0) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/formatter/SassRootBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/formatter/SassRootBlock", "getChildAttributes"));
        }
        return childAttributes;
    }
}

