/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.spellchecking;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;

public class SassScssSpellcheckingStrategy
extends SpellcheckingStrategy {
    private static final Tokenizer VARIABLE_TOKENIZER = new Tokenizer<SassScssVariableImpl>(){

        public void tokenize(@NotNull SassScssVariableImpl element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/spellchecking/SassScssSpellcheckingStrategy$1", "tokenize"));
            }
            TextRange range = element.getTextRange();
            if (range.isEmpty()) {
                return;
            }
            String text = element.getText().substring(1);
            consumer.consumeToken((PsiElement)element, text, true, 1, TextRange.allOf((String)text), (Splitter)IdentifierSplitter.getInstance());
        }
    };

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof SassScssVariableImpl) {
            Tokenizer tokenizer = VARIABLE_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/spellchecking/SassScssSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof SassScssVariableDeclaration) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/spellchecking/SassScssSpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/spellchecking/SassScssSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }
}

