/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.io.File;
import org.tmatesoft.svn.core.internal.util.jna.ISVNKernel32Library;
import org.tmatesoft.svn.core.internal.util.jna.ISVNWin32Library;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

class SVNWin32Util {
    SVNWin32Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWritable(File file) {
        if (file == null) {
            return false;
        }
        ISVNKernel32Library library = JNALibraryLoader.getKernelLibrary();
        if (library == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library = library;
        synchronized (iSVNKernel32Library) {
            try {
                int rc = library.SetFileAttributesW(new WString(file.getAbsolutePath()), new NativeLong(128L));
                return rc != 0;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setHidden(File file) {
        if (file == null) {
            return false;
        }
        ISVNKernel32Library library = JNALibraryLoader.getKernelLibrary();
        if (library == null) {
            return false;
        }
        ISVNKernel32Library iSVNKernel32Library = library;
        synchronized (iSVNKernel32Library) {
            try {
                int rc = library.SetFileAttributesW(new WString(file.getAbsolutePath()), new NativeLong(2L));
                return rc != 0;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(File src, File dst) {
        if (src == null || dst == null) {
            return false;
        }
        ISVNKernel32Library library = JNALibraryLoader.getKernelLibrary();
        if (library == null) {
            return false;
        }
        if (dst.isFile() && !dst.canWrite()) {
            SVNFileUtil.setReadonly(dst, false);
            SVNFileUtil.setReadonly(src, true);
        }
        ISVNKernel32Library iSVNKernel32Library = library;
        synchronized (iSVNKernel32Library) {
            int errorCode = 0;
            int attempts = SVNFileUtil.FILE_CREATION_ATTEMPTS_COUNT;
            long sleep = 1L;
            do {
                int rc = 0;
                try {
                    rc = library.MoveFileExW(new WString(src.getAbsoluteFile().getAbsolutePath()), new WString(dst.getAbsoluteFile().getAbsolutePath()), new NativeLong(3L));
                }
                catch (Throwable th) {
                    return false;
                }
                if (rc != 0) {
                    return true;
                }
                errorCode = library.GetLastError();
                --attempts;
                if (errorCode != 5) continue;
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (sleep >= 128L) continue;
                sleep *= 2L;
            } while (errorCode == 5 && attempts >= 0);
        }
        return false;
    }

    public static String getApplicationDataPath(boolean common) {
        char[] commonAppDataPath;
        ISVNWin32Library library = JNALibraryLoader.getWin32Library();
        if (library == null) {
            return null;
        }
        int type = common ? 35 : 26;
        ISVNWin32Library.HRESULT result = library.SHGetFolderPathW(Pointer.NULL, type, Pointer.NULL, ISVNWin32Library.SHGFP_TYPE_CURRENT, commonAppDataPath = new char[1024]);
        if (result == null || result.longValue() != 0L) {
            return null;
        }
        int length = commonAppDataPath.length;
        for (int i = 0; i < commonAppDataPath.length; ++i) {
            if (commonAppDataPath[i] != '\u0000') continue;
            length = i;
            break;
        }
        String path = new String(commonAppDataPath, 0, length);
        path = path.replace(File.separatorChar, '/');
        return path;
    }
}

