/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.HAMLLanguage;
import org.jetbrains.plugins.haml.psi.HAMLFile;

public class HamlTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(PsiFile file) {
        return file instanceof HAMLFile;
    }

    public String getConsumeMessage() {
        return "Enable File Watcher to compile HAML to HTML?";
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(HAMLLanguage.INSTANCE.getDisplayName());
        options.setDescription("Compiles .haml files into .html files");
        options.setFileExtension("haml");
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        options.setArguments("$" + new FileNameMacro().getName() + "$ $" + new FileNameWithoutExtension().getName() + "$.html");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setOutput("$" + new FileNameWithoutExtension().getName() + "$.html");
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/watcher/HamlTaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/haml/watcher/HamlTaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/haml/watcher/HamlTaskConsumer", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        options.setProgram(HamlTaskConsumer.findExecutableInPath((String)"haml"));
    }
}

