/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addattribute;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;

class AddAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JLabel attributeValueLabel = new JLabel();
    private final JTextField attributeNameField;
    private final JTextField attributeValueField;
    private final JCheckBox addIfAbsentCheckbox;
    private final XmlTag tag;

    AddAttributeDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.tag = tag;
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Add Attribute");
        this.attributeNameLabel.setText("Name for new attribute");
        this.attributeNameField = new JTextField();
        this.attributeValueLabel.setText("Value for new attribute");
        this.attributeValueField = new JTextField();
        this.addIfAbsentCheckbox = new JCheckBox("Add attribute only if absent");
        this.addIfAbsentCheckbox.setSelected(true);
        Document document = this.attributeNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.AddAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.attributeNameField;
    }

    public String getAttributeName() {
        String text = this.attributeNameField.getText();
        return text.trim();
    }

    public String getAttributeValue() {
        String text = this.attributeValueField.getText();
        return text.trim();
    }

    public boolean getAddOnlyIfAbsent() {
        return this.addIfAbsentCheckbox.isSelected();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Add attribute to tag " + tagName), (boolean)true);
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.attributeNameField.setEditable(true);
        box.add(this.attributeNameField);
        box.add(this.attributeValueLabel);
        box.add(this.attributeValueField);
        box.add(this.addIfAbsentCheckbox);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        return XMLUtil.attributeNameIsValid(this.getAttributeName()) && this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String attributeName = this.getAttributeName();
        String attributeValue = this.getAttributeValue();
        if (this.getAddOnlyIfAbsent()) {
            return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy>\n\t\t<xsl:attribute name=\"" + attributeName + "\">" + attributeValue + "</xsl:attribute>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>\n<xsl:template match=\"" + tagName + "[@" + attributeName + "]\">\n\t<xsl:copy>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>";
        }
        return "<xsl:template match=\"" + tagName + "\">\n\t<xsl:copy>\n\t\t<xsl:attribute name=\"" + attributeName + "\">" + attributeValue + "</xsl:attribute>\n\t\t<xsl:apply-templates select=\"@*|node()\"/>\n\t</xsl:copy>\n</xsl:template>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.addAttribute");
    }
}

