/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addattribute;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.addattribute.AddAttribute;
import com.sixrr.xrp.addattribute.AddAttributeUsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AddAttributeProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String attributeName;
    private final String attributeValue;
    private final boolean addOnlyIfAbsent;
    private final Context context;

    AddAttributeProcessor(XmlTag tag, String attributeName, String attributeValue, boolean addOnlyIfAbsent, Context context) {
        super(tag.getProject());
        this.attributeValue = attributeValue;
        this.attributeName = attributeName;
        this.tag = tag;
        this.addOnlyIfAbsent = addOnlyIfAbsent;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/addattribute/AddAttributeProcessor", "createUsageViewDescriptor"));
        }
        AddAttributeUsageViewDescriptor addAttributeUsageViewDescriptor = new AddAttributeUsageViewDescriptor(this.tag, usageInfos);
        if (addAttributeUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/addattribute/AddAttributeProcessor", "createUsageViewDescriptor"));
        }
        return addAttributeUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/addattribute/AddAttributeProcessor", "findUsages"));
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (this.addOnlyIfAbsent && xmlTag.getAttributeValue(this.attributeName) != null) continue;
            usages.add(new AddAttribute(xmlTag, this.attributeName, this.attributeValue));
        }
    }

    protected String getCommandName() {
        return "Add attribute " + this.attributeName + " to tag " + this.tag.getName();
    }
}

