/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.moveattributein;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.moveattributein.MoveAttributeIn;
import com.sixrr.xrp.moveattributein.MoveAttributeInUsageViewDescriptor;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.psi.XMLMutationUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MoveAttributeInProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlAttribute attribute;
    private final String tagName;
    private final Context context;

    MoveAttributeInProcessor(XmlAttribute attribute, String tagName, Context context) {
        super(attribute.getProject());
        this.attribute = attribute;
        this.tagName = tagName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/moveattributein/MoveAttributeInProcessor", "createUsageViewDescriptor"));
        }
        MoveAttributeInUsageViewDescriptor moveAttributeInUsageViewDescriptor = new MoveAttributeInUsageViewDescriptor(this.attribute, usageInfos);
        if (moveAttributeInUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/moveattributein/MoveAttributeInProcessor", "createUsageViewDescriptor"));
        }
        return moveAttributeInUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/moveattributein/MoveAttributeInProcessor", "findUsages"));
        }
        String attributeName = this.attribute.getName();
        String attributeNamespace = this.attribute.getNamespace();
        XmlTag parentTag = this.attribute.getParent();
        String existingTagName = parentTag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(existingTagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            XmlAttribute foundAttribute;
            if (XMLMutationUtils.isSpecialJSPTag(xmlTag) || (foundAttribute = xmlTag.getAttribute(attributeName, attributeNamespace)) == null) continue;
            usages.add(new MoveAttributeIn(xmlTag, this.tagName, attributeName, attributeNamespace));
        }
    }

    protected String getCommandName() {
        return "Move attribute " + this.attribute.getName() + "in";
    }
}

