/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.tagtoattribute.ReplaceTagWithAttribute;
import com.sixrr.xrp.tagtoattribute.TagToAttributeUsageViewDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TagToAttributeProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String attributeName;
    private final Context context;

    TagToAttributeProcessor(XmlTag tag, String attributeName, Context context) {
        super(tag.getProject());
        this.tag = tag;
        this.attributeName = attributeName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/tagtoattribute/TagToAttributeProcessor", "createUsageViewDescriptor"));
        }
        TagToAttributeUsageViewDescriptor tagToAttributeUsageViewDescriptor = new TagToAttributeUsageViewDescriptor(this.tag, usageInfos);
        if (tagToAttributeUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/tagtoattribute/TagToAttributeProcessor", "createUsageViewDescriptor"));
        }
        return tagToAttributeUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/tagtoattribute/TagToAttributeProcessor", "findUsages"));
        }
        XmlTag parentTag = (XmlTag)this.tag.getParent();
        String parentTagName = parentTag.getName();
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            XmlTag testParentTag;
            XmlTag[] subTags = xmlTag.getSubTags();
            if (subTags.length != 0 || (testParentTag = xmlTag.getParentTag()) == null || !parentTagName.equals(testParentTag.getName())) continue;
            usages.add(new ReplaceTagWithAttribute(xmlTag, this.attributeName));
        }
    }

    protected String getCommandName() {
        return "Replace tag " + this.tag.getName() + " with attribute";
    }
}

