/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.unwraptag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.unwraptag.UnwrapTag;
import com.sixrr.xrp.unwraptag.UnwrapTagUsageViewDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class UnwrapTagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final Context context;

    UnwrapTagProcessor(XmlTag tag, Context context) {
        super(tag.getProject());
        this.tag = tag;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/unwraptag/UnwrapTagProcessor", "createUsageViewDescriptor"));
        }
        UnwrapTagUsageViewDescriptor unwrapTagUsageViewDescriptor = new UnwrapTagUsageViewDescriptor(this.tag, usageInfos);
        if (unwrapTagUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/unwraptag/UnwrapTagProcessor", "createUsageViewDescriptor"));
        }
        return unwrapTagUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/unwraptag/UnwrapTagProcessor", "findUsages"));
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (xmlTag.getParentTag() == null) continue;
            usages.add(new UnwrapTag(xmlTag));
        }
    }

    protected String getCommandName() {
        return "Unwrap tag " + this.tag.getName();
    }
}

