/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.wraptag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.wraptag.WrapTag;
import com.sixrr.xrp.wraptag.WrapTagUsageViewDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class WrapTagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String parentTagName;
    private final Context context;

    WrapTagProcessor(XmlTag tag, String parentTagName, Context context) {
        super(tag.getProject());
        this.tag = tag;
        this.parentTagName = parentTagName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/wraptag/WrapTagProcessor", "createUsageViewDescriptor"));
        }
        WrapTagUsageViewDescriptor wrapTagUsageViewDescriptor = new WrapTagUsageViewDescriptor(this.tag, usageInfos);
        if (wrapTagUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/wraptag/WrapTagProcessor", "createUsageViewDescriptor"));
        }
        return wrapTagUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/wraptag/WrapTagProcessor", "findUsages"));
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            usages.add(new WrapTag(xmlTag, this.parentTagName));
        }
    }

    protected String getCommandName() {
        return "Wrap tag " + this.tag.getName();
    }
}

