/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.wraptagcontents;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.wraptagcontents.WrapTagContents;
import com.sixrr.xrp.wraptagcontents.WrapTagContentsUsageViewDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class WrapTagContentsProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String wrapTagName;
    private final Context context;

    WrapTagContentsProcessor(XmlTag tag, String wrapTagName, Context context) {
        super(tag.getProject());
        this.tag = tag;
        this.wrapTagName = wrapTagName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/wraptagcontents/WrapTagContentsProcessor", "createUsageViewDescriptor"));
        }
        WrapTagContentsUsageViewDescriptor wrapTagContentsUsageViewDescriptor = new WrapTagContentsUsageViewDescriptor(this.tag, usageInfos);
        if (wrapTagContentsUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/wraptagcontents/WrapTagContentsProcessor", "createUsageViewDescriptor"));
        }
        return wrapTagContentsUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/wraptagcontents/WrapTagContentsProcessor", "findUsages"));
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            usages.add(new WrapTagContents(xmlTag, this.wrapTagName));
        }
    }

    protected String getCommandName() {
        return "Wrap content of tag " + this.tag.getName() + " with tag " + this.wrapTagName;
    }
}

