/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation;

import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.core.model.presentation.components.DummyTapestryParameter;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParameterReceiverElement
extends PresentationLibraryElement {
    private Map<String, TapestryParameter> _parametersCache;
    private long _parametersCacheTimestamp;

    ParameterReceiverElement(@Nullable Library library, @NotNull IJavaClassType elementClass, @NotNull TapestryProject project) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/tapestry/core/model/presentation/ParameterReceiverElement", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tapestry/core/model/presentation/ParameterReceiverElement", "<init>"));
        }
        super(library, elementClass, project);
    }

    @NotNull
    public Map<String, TapestryParameter> getParameters() {
        if (this._parametersCache != null && this.getElementClass().getFile().getFile().lastModified() <= this._parametersCacheTimestamp) {
            Map<String, TapestryParameter> map = this._parametersCache;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/model/presentation/ParameterReceiverElement", "getParameters"));
            }
            return map;
        }
        THashMap _parameters = new THashMap();
        _parameters.put("mixins", new DummyTapestryParameter(this.getProject(), "mixins", false));
        this._parametersCacheTimestamp = this.getElementClass().getFile().getFile().lastModified();
        Map<String, IJavaField> fields = this.getElementClass().getFields(true);
        for (IJavaField field : fields.values()) {
            if (!field.isPrivate() || !field.getAnnotations().containsKey("org.apache.tapestry5.annotations.Parameter") || !field.isValid()) continue;
            TapestryParameter parameter = new TapestryParameter(this.getElementClass(), field);
            _parameters.put(parameter.getName(), parameter);
        }
        Map<String, TapestryParameter> map = this._parametersCache = Collections.unmodifiableMap(_parameters);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/model/presentation/ParameterReceiverElement", "getParameters"));
        }
        return map;
    }

    @NotNull
    public Map<String, TapestryParameter> getRequiredParameters() {
        Map<String, TapestryParameter> parameters = this.getParameters();
        THashMap requiredParameters = new THashMap();
        for (TapestryParameter parameter : parameters.values()) {
            if (!parameter.isRequired()) continue;
            requiredParameters.put(parameter.getName(), parameter);
        }
        THashMap tHashMap = requiredParameters;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/model/presentation/ParameterReceiverElement", "getRequiredParameters"));
        }
        return tHashMap;
    }

    public Map<String, TapestryParameter> getOptionalParameters() {
        Map<String, TapestryParameter> parameters = this.getParameters();
        THashMap optionalParameters = new THashMap();
        for (TapestryParameter parameter : parameters.values()) {
            if (parameter.isRequired()) continue;
            optionalParameters.put(parameter.getName(), parameter);
        }
        return optionalParameters;
    }
}

