/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class LocalizationUtils {
    private static final List<String> ALL_COUNTRIES = Arrays.asList(Locale.getISOCountries());
    private static final List<String> ALL_LANGUAGES = Arrays.asList(Locale.getISOLanguages());

    public static String unlocalizeFileName(String filename) {
        int lastDot = filename.lastIndexOf(46);
        int extension = lastDot >= 0 ? lastDot : filename.length();
        int lastUnderscore = filename.lastIndexOf(95, extension);
        if (lastUnderscore < 1) {
            return filename;
        }
        String languageOrCountry = filename.substring(lastUnderscore + 1, extension);
        if (ALL_LANGUAGES.contains(languageOrCountry)) {
            return LocalizationUtils.removeSubstring(filename, lastUnderscore, extension);
        }
        if (!ALL_COUNTRIES.contains(languageOrCountry)) {
            return filename;
        }
        int nextUnderscore = filename.lastIndexOf(95, lastUnderscore - 1);
        if (nextUnderscore < 1) {
            return filename;
        }
        String language = filename.substring(nextUnderscore + 1, lastUnderscore);
        return ALL_LANGUAGES.contains(language) ? LocalizationUtils.removeSubstring(filename, nextUnderscore, extension) : filename;
    }

    private static String removeSubstring(String filename, int beginIndex, int endIndex) {
        return filename.substring(0, beginIndex) + filename.substring(endIndex);
    }
}

