/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class WebDescriptorUtils {
    public static final String APPLICATION_PACKAGE_PARAMETER_NAME = "tapestry.app-package";
    private static final String CONTEXT_PARAM_NAME = "param-name";
    private static final String CONTEXT_PARAM_VALUE = "param-value";

    public static String getTapestryFilterName(Document document) {
        NodeList nodeList = document.getElementsByTagName("filter-class");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getTextContent().equals("org.apache.tapestry5.TapestryFilter")) continue;
            NodeList paramNodeList = nodeList.item(i).getParentNode().getChildNodes();
            for (int j = 0; j < paramNodeList.getLength(); ++j) {
                if (!paramNodeList.item(j).getNodeName().equals("filter-name")) continue;
                return paramNodeList.item(j).getTextContent();
            }
        }
        return null;
    }

    public static String getApplicationPackage(Document document) {
        return WebDescriptorUtils.getContextParam(document, APPLICATION_PACKAGE_PARAMETER_NAME);
    }

    private static String getContextParam(@Nullable Document document, @NotNull String paramName) {
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/intellij/tapestry/core/util/WebDescriptorUtils", "getContextParam"));
        }
        if (document == null) {
            return null;
        }
        NodeList nodeList = document.getElementsByTagName(CONTEXT_PARAM_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!paramName.equals(nodeList.item(i).getTextContent())) continue;
            NodeList paramNodeList = nodeList.item(i).getParentNode().getChildNodes();
            for (int j = 0; j < paramNodeList.getLength(); ++j) {
                if (!paramNodeList.item(j).getNodeName().equals(CONTEXT_PARAM_VALUE)) continue;
                return paramNodeList.item(j).getTextContent();
            }
        }
        return null;
    }
}

