/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang;

import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.tapestry.lang.TmlHighlighter;
import icons.TapestryIcons;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TemplateColorSettingsPage
implements ColorSettingsPage {
    public static final TextAttributesKey TAG_NAME = TemplateColorSettingsPage.createTextAttributesKey("TAPESTRY_COMPONENT_TAG", XmlHighlighterColors.HTML_TAG_NAME);
    public static final TextAttributesKey ATTR_NAME = TemplateColorSettingsPage.createTextAttributesKey("TAPESTRY_COMPONENT_PARAMATER", XmlHighlighterColors.HTML_ATTRIBUTE_NAME);
    public static final TextAttributesKey TEL_BOUNDS = TemplateColorSettingsPage.createTextAttributesKey("TEL_BOUNDS", JavaHighlightingColors.KEYWORD);
    public static final TextAttributesKey TEL_IDENT = TemplateColorSettingsPage.createTextAttributesKey("TEL_IDENT", JavaHighlightingColors.LOCAL_VARIABLE_ATTRIBUTES);
    public static final TextAttributesKey TEL_DOT = TemplateColorSettingsPage.createTextAttributesKey("TEL_DOT", JavaHighlightingColors.DOT);
    public static final TextAttributesKey TEL_NUMBER = TemplateColorSettingsPage.createTextAttributesKey("TEL_NUMBER", JavaHighlightingColors.NUMBER);
    public static final TextAttributesKey TEL_PARENTHS = TemplateColorSettingsPage.createTextAttributesKey("TEL_PARENTHS", JavaHighlightingColors.PARENTHESES);
    public static final TextAttributesKey TEL_BRACKETS = TemplateColorSettingsPage.createTextAttributesKey("TEL_BRACKETS", JavaHighlightingColors.BRACKETS);
    public static final TextAttributesKey TEL_STRING = TemplateColorSettingsPage.createTextAttributesKey("TEL_STRING", JavaHighlightingColors.STRING);
    public static final TextAttributesKey TEL_BACKGROUND = TemplateColorSettingsPage.createTextAttributesKey("TEL_BACKGROUND", JspHighlighterColors.JSP_SCRIPTING_BACKGROUND);
    public static final TextAttributesKey TEL_BAD_CHAR = TemplateColorSettingsPage.createTextAttributesKey("TEL_BAD_CHAR", HighlighterColors.BAD_CHARACTER);
    private static final AttributesDescriptor[] ourAttributeDescriptors = new AttributesDescriptor[]{TemplateColorSettingsPage.createAttributesDescriptor("Component tag", TAG_NAME), TemplateColorSettingsPage.createAttributesDescriptor("Component parameter", ATTR_NAME), TemplateColorSettingsPage.createAttributesDescriptor("EL bounds", TEL_BOUNDS), TemplateColorSettingsPage.createAttributesDescriptor("EL identifier", TEL_IDENT), TemplateColorSettingsPage.createAttributesDescriptor("EL dot", TEL_DOT), TemplateColorSettingsPage.createAttributesDescriptor("EL number", TEL_NUMBER), TemplateColorSettingsPage.createAttributesDescriptor("EL parenths", TEL_PARENTHS), TemplateColorSettingsPage.createAttributesDescriptor("EL brackets", TEL_BRACKETS), TemplateColorSettingsPage.createAttributesDescriptor("EL string", TEL_STRING), TemplateColorSettingsPage.createAttributesDescriptor("EL background", TEL_BACKGROUND), TemplateColorSettingsPage.createAttributesDescriptor("Bad character", TEL_BAD_CHAR)};
    private static final Map<String, TextAttributesKey> ourAdditionalHighlightingTagToDescriptorMap;
    private static final String ourColorSettingsText;

    private static TextAttributesKey createTextAttributesKey(@NonNls String externalName, TextAttributesKey defaultTextAttr) {
        return TextAttributesKey.createTextAttributesKey((String)externalName, (TextAttributesKey)defaultTextAttr);
    }

    private static AttributesDescriptor createAttributesDescriptor(String displayNameKey, TextAttributesKey textAttributesKey) {
        return new AttributesDescriptor(displayNameKey, textAttributesKey);
    }

    @NotNull
    public String getDisplayName() {
        if ("Tapestry" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/TemplateColorSettingsPage", "getDisplayName"));
        }
        return "Tapestry";
    }

    public Icon getIcon() {
        return TapestryIcons.Tapestry_logo_small;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ourAttributeDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/TemplateColorSettingsPage", "getAttributeDescriptors"));
        }
        return ourAttributeDescriptors;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/TemplateColorSettingsPage", "getColorDescriptors"));
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        TmlHighlighter tmlHighlighter = new TmlHighlighter();
        if (tmlHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/TemplateColorSettingsPage", "getHighlighter"));
        }
        return tmlHighlighter;
    }

    @NotNull
    public String getDemoText() {
        String string = ourColorSettingsText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/TemplateColorSettingsPage", "getDemoText"));
        }
        return string;
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ourAdditionalHighlightingTagToDescriptorMap;
    }

    static {
        Logger logger = Logger.getInstance(TemplateColorSettingsPage.class);
        String template = "";
        try {
            template = FileUtil.loadTextAndClose((InputStream)TemplateColorSettingsPage.class.getResourceAsStream("templateColorSettingsText.html"));
            if (template.isEmpty()) {
                logger.warn("Template color settings demo text is empty");
            }
        }
        catch (IOException ex) {
            logger.error((Throwable)ex);
        }
        ourColorSettingsText = template.replace('\r', ' ');
        ourAdditionalHighlightingTagToDescriptorMap = new HashMap<String, TextAttributesKey>();
        ourAdditionalHighlightingTagToDescriptorMap.put("componenTagName", TAG_NAME);
        ourAdditionalHighlightingTagToDescriptorMap.put("componenTagAttribute", ATTR_NAME);
    }
}

