/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.reference;

import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.java.IJavaMethod;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.Page;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ResolvedValue;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverChain;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.java.IntellijJavaField;
import com.intellij.tapestry.intellij.core.java.IntellijJavaMethod;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.intellij.lang.reference.PsiAttributeValueReference;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.psi.TmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryReferenceContributor
extends PsiReferenceContributor {
    private static final PatternCondition<XmlElement> tapestryFileCondition = new PatternCondition<XmlElement>("tapestryFileCondition"){

        public boolean accepts(@NotNull XmlElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$1", "accepts"));
            }
            return element.getContainingFile() instanceof TmlFile;
        }
    };
    private static final Key<XmlTag> TAG_KEY = Key.create((String)"TAG_KEY");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "registerReferenceProviders"));
        }
        String[] tapestryTemplateNamespaces = TapestryXmlExtension.tapestryTemplateNamespaces();
        TapestryReferenceContributor.registerTypeAttrValueReferenceProvider(registrar, tapestryTemplateNamespaces);
        TapestryReferenceContributor.registerIdAttrValueReferenceProvider(registrar, tapestryTemplateNamespaces);
        TapestryReferenceContributor.registerAttrValueReferenceProvider(registrar);
        TapestryReferenceContributor.registerLinkHrefReference(registrar);
    }

    private static void registerLinkHrefReference(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "registerLinkHrefReference"));
        }
        registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"href"}).inside((ElementPattern)XmlPatterns.xmlTag().withName("link"))).with(tapestryFileCondition), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$2", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(element, true, false, true, new PathReferenceProvider[0]);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static void registerTypeAttrValueReferenceProvider(PsiReferenceRegistrar registrar, String[] tapestryTemplateNamespaces) {
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"type"}).withNamespace(tapestryTemplateNamespaces).with(tapestryFileCondition), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$3", "getReferencesByElement"));
                }
                XmlAttributeValue typeAttrValue = (XmlAttributeValue)element;
                PsiReference[] psiReferenceArray = TapestryReferenceContributor.getReferenceToComponentClass(typeAttrValue, ElementManipulators.getValueTextRange((PsiElement)typeAttrValue));
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$3", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"alt"}).with(tapestryFileCondition), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$4", "getReferencesByElement"));
                }
                String value = StringUtil.stripQuotesAroundValue((String)element.getText());
                String prefix = "message:";
                if (value.startsWith("message:")) {
                    String key = value.substring("message:".length());
                    int valueStart = "message:".length() + 1;
                    PsiReference[] psiReferenceArray = new PsiReference[]{new PropertyReference(key, element, null, true, new TextRange(valueStart, valueStart + key.length()))};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$4", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$4", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }

    private static void registerIdAttrValueReferenceProvider(PsiReferenceRegistrar registrar, String[] tapestryTemplateNamespaces) {
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"id"}).withNamespace(tapestryTemplateNamespaces).with(tapestryFileCondition), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$5", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$5", "getReferencesByElement"));
                }
                XmlAttributeValue idAttrValue = (XmlAttributeValue)element;
                XmlElement identifier = TapestryUtils.getComponentIdentifier(TapestryReferenceContributor.parentTag(idAttrValue));
                TextRange valueTextRange = ElementManipulators.getValueTextRange((PsiElement)idAttrValue);
                PsiReference[] psiReferenceArray = identifier == idAttrValue.getParent() ? TapestryReferenceContributor.getReferenceToEmbeddedComponent(idAttrValue, valueTextRange) : TapestryReferenceContributor.getReferenceByComponentId(idAttrValue, valueTextRange);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$5", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static XmlTag parentTag(XmlAttributeValue value) {
        PsiElement parent = value.getParent();
        if (parent instanceof XmlAttribute) {
            return ((XmlAttribute)parent).getParent();
        }
        return null;
    }

    private static void registerAttrValueReferenceProvider(PsiReferenceRegistrar registrar) {
        PatternCondition<XmlTag> tapestryTagCondition = new PatternCondition<XmlTag>("tapestryTagCondition"){

            public boolean accepts(@NotNull XmlTag tag, ProcessingContext context) {
                if (tag == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$6", "accepts"));
                }
                return tag.getContainingFile() instanceof TmlFile && TapestryUtils.getTypeOfTag(tag) != null;
            }
        };
        XmlAttributeValuePattern tapestryAttributeValuePattern = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().with((PatternCondition)tapestryTagCondition)).save(TAG_KEY));
        registrar.registerReferenceProvider((ElementPattern)tapestryAttributeValuePattern, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$7", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$7", "getReferencesByElement"));
                }
                XmlAttributeValue attrValue = (XmlAttributeValue)element;
                XmlTag tag = (XmlTag)context.get(TAG_KEY);
                Component component = TapestryUtils.getTypeOfTag(tag);
                if (component == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$7", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiElement parent = attrValue.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$7", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String localName = ((XmlAttribute)parent).getLocalName();
                TapestryParameter parameter = component.getParameters().get(localName);
                if (parameter == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$7", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = localName.equals("page") ? TapestryReferenceContributor.getReferenceToPage(component, attrValue) : TapestryReferenceContributor.getAttrValueReference(attrValue, component.getProject(), parameter);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$7", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static PsiReference[] getAttrValueReference(XmlAttributeValue attrValue, TapestryProject project, TapestryParameter parameter) {
        ResolvedValue resolvedValue;
        PresentationLibraryElement element = project.findElementByTemplate(attrValue.getContainingFile());
        if (element == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        IntellijJavaClassType elementClass = (IntellijJavaClassType)element.getElementClass();
        try {
            resolvedValue = ValueResolverChain.getInstance().resolve(project, elementClass, attrValue.getValue(), parameter.getDefaultPrefix());
        }
        catch (Exception ex) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (resolvedValue == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (resolvedValue.getCodeBind() instanceof IJavaMethod) {
            return new PsiReference[]{new PsiAttributeValueReference(attrValue, (PsiElement)((IntellijJavaMethod)resolvedValue.getCodeBind()).getPsiMethod())};
        }
        if (resolvedValue.getCodeBind() instanceof IJavaField) {
            return new PsiReference[]{new PsiAttributeValueReference(attrValue, (PsiElement)((IntellijJavaField)resolvedValue.getCodeBind()).getPsiField())};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    private static PsiReference[] getReferenceToComponentClass(@NotNull XmlAttributeValue attributeValue, @Nullable TextRange range) {
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToComponentClass"));
        }
        if (range == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToComponentClass"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final XmlTag tag = TapestryReferenceContributor.parentTag(attributeValue);
        if (tag == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToComponentClass"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Component component = TapestryUtils.getTypeOfTag(tag);
        final IntellijJavaClassType elementClass = component == null ? null : (IntellijJavaClassType)component.getElementClass();
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>((PsiElement)attributeValue, range){

            @Nullable
            public PsiElement resolve() {
                return elementClass == null ? null : elementClass.getPsiClass();
            }

            @NotNull
            public Object[] getVariants() {
                TapestryProject project = TapestryModuleSupportLoader.getTapestryProject((XmlElement)tag);
                Object[] objectArray = project == null ? EMPTY_ARRAY : project.getAvailableComponentNames();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$8", "getVariants"));
                }
                return objectArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToComponentClass"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getReferenceToEmbeddedComponent(@NotNull XmlAttributeValue attr, TextRange range) {
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToEmbeddedComponent"));
        }
        if (range == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToEmbeddedComponent"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final XmlTag tag = TapestryReferenceContributor.parentTag(attr);
        final IntellijJavaField field = (IntellijJavaField)TapestryUtils.findIdentifyingField(tag);
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>((PsiElement)attr, range){

            @Nullable
            public PsiElement resolve() {
                return field == null ? null : field.getPsiField();
            }

            @NotNull
            public Object[] getVariants() {
                List<String> fieldsIds = TapestryUtils.getEmbeddedComponentIds(tag);
                Object[] objectArray = ArrayUtil.toStringArray(fieldsIds);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$9", "getVariants"));
                }
                return objectArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToEmbeddedComponent"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getReferenceByComponentId(final @NotNull XmlAttributeValue attrValue, TextRange range) {
        if (attrValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrValue", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceByComponentId"));
        }
        if (range == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceByComponentId"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>((PsiElement)attrValue, range){

            @Nullable
            public PsiElement resolve() {
                return attrValue;
            }

            @NotNull
            public Object[] getVariants() {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$10", "getVariants"));
                }
                return EMPTY_ARRAY;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceByComponentId"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] getReferenceToPage(final Component component, @NotNull XmlAttributeValue pageAttrValue) {
        if (pageAttrValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageAttrValue", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToPage"));
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)pageAttrValue);
        if (range == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToPage"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final Page page = component.getProject().findPage(pageAttrValue.getValue());
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>((PsiElement)pageAttrValue, range){

            @Nullable
            public PsiElement resolve() {
                if (page == null) {
                    return null;
                }
                IResource[] templates = page.getTemplate();
                return templates.length == 0 ? null : ((IntellijResource)templates[0]).getPsiFile();
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = component.getProject().getAvailablePageNames();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor$11", "getVariants"));
                }
                return objectArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/reference/TapestryReferenceContributor", "getReferenceToPage"));
        }
        return psiReferenceArray;
    }
}

