/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryPropertyNamingUtil {
    private TapestryPropertyNamingUtil() {
    }

    public static boolean isWaitOrNotifyOfObject(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil", "isWaitOrNotifyOfObject"));
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null || !"java.lang.Object".equals(psiClass.getQualifiedName())) {
            return false;
        }
        String name = method.getName();
        return "wait".equals(name) || "notify".equals(name) || "notifyAll".equals(name);
    }

    public static boolean isPropertyGetter(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil", "isPropertyGetter"));
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        PsiType returnType = method.getReturnType();
        if (methodName.startsWith("get") && methodName.length() > "get".length()) {
            if (returnType == null || PsiType.VOID.equals((Object)returnType)) {
                return false;
            }
        } else if (methodName.startsWith("is")) {
            if (!PsiType.BOOLEAN.equals((Object)returnType)) {
                return false;
            }
        } else {
            return false;
        }
        return method.getParameterList().getParametersCount() == 0;
    }

    public static boolean isPropertySetter(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil", "isPropertySetter"));
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        return methodName.startsWith("set") && methodName.length() > "set".length() && method.getParameterList().getParametersCount() == 1 && (method.getReturnType() == null || PsiType.VOID.equals((Object)method.getReturnType()));
    }

    public static boolean isPropertyAccessor(PsiMethod method) {
        return TapestryPropertyNamingUtil.isPropertyGetter(method) || TapestryPropertyNamingUtil.isPropertySetter(method);
    }

    @Nullable
    public static String getPropertyNameFromAccessor(@NotNull PsiMethod accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil", "getPropertyNameFromAccessor"));
        }
        if (TapestryPropertyNamingUtil.isPropertySetter(accessor)) {
            return TapestryPropertyNamingUtil.getPropertyNameFromSetter(accessor);
        }
        if (TapestryPropertyNamingUtil.isPropertyGetter(accessor)) {
            return TapestryPropertyNamingUtil.getPropertyNameFromGetter(accessor);
        }
        return null;
    }

    private static String getPropertyNameFromGetter(@NotNull PsiMethod getter) {
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil", "getPropertyNameFromGetter"));
        }
        String methodName = getter.getName();
        int prefixLength = methodName.startsWith("get") ? "get".length() : "is".length();
        return methodName.substring(prefixLength);
    }

    private static String getPropertyNameFromSetter(@NotNull PsiMethod setter) {
        if (setter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setter", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil", "getPropertyNameFromSetter"));
        }
        return setter.getName().substring("set".length());
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, String propertyName) {
        return TapestryPropertyNamingUtil.findPropertyAccessor(aClass, propertyName, new PropertyNameExtractor(){

            @Override
            public String extractPropertyName(@NotNull PsiMethod method) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil$1", "extractPropertyName"));
                }
                return TapestryPropertyNamingUtil.isPropertyGetter(method) ? TapestryPropertyNamingUtil.getPropertyNameFromGetter(method) : null;
            }
        });
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName) {
        return TapestryPropertyNamingUtil.findPropertyAccessor(aClass, propertyName, new PropertyNameExtractor(){

            @Override
            public String extractPropertyName(@NotNull PsiMethod method) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/tapestry/intellij/util/TapestryPropertyNamingUtil$2", "extractPropertyName"));
                }
                return TapestryPropertyNamingUtil.isPropertySetter(method) ? TapestryPropertyNamingUtil.getPropertyNameFromSetter(method) : null;
            }
        });
    }

    @Nullable
    private static PsiMethod findPropertyAccessor(PsiClass aClass, String propertyName, PropertyNameExtractor extractor) {
        if (aClass == null) {
            return null;
        }
        for (PsiMethod method : aClass.getAllMethods()) {
            String wouldBePropertyName = extractor.extractPropertyName(method);
            if (!propertyName.equalsIgnoreCase(wouldBePropertyName)) continue;
            return method;
        }
        return null;
    }

    private static interface PropertyNameExtractor {
        @Nullable
        public String extractPropertyName(@NotNull PsiMethod var1);
    }
}

