/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.tapestry.lang.TelFileType;
import com.intellij.tapestry.psi.TelArgumentList;
import com.intellij.tapestry.psi.TelCompositeElement;
import com.intellij.tapestry.psi.TelLiteralExpressionType;
import com.intellij.tapestry.psi.TelMethodCallExpression;
import com.intellij.tapestry.psi.TelNotOpExpression;
import com.intellij.tapestry.psi.TelRangeExpression;
import com.intellij.tapestry.psi.TelReferenceExpression;
import com.intellij.tapestry.psi.TelTokenTypes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class TelCompositeElementType
extends IElementType
implements ICompositeElementType {
    public static final TelCompositeElementType EXPLICIT_BINDING = new TelCompositeElementType("ExplicitBinding"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new TelCompositeElement(node){

                @NotNull
                public PsiReference[] getReferences() {
                    ASTNode child = this.getNode().findChildByType((IElementType)TelTokenTypes.TAP5_EL_IDENTIFIER);
                    if (child != null && "message".equals(child.getText()) && (child = this.getNode().findChildByType((IElementType)TelTokenTypes.TAP5_EL_IDENTIFIER, child.getTreeNext())) != null) {
                        PsiElement psi = child.getPsi();
                        int startOffsetInParent = psi.getStartOffsetInParent();
                        PsiReference[] psiReferenceArray = new PsiReference[]{new PropertyReference(psi.getText(), (PsiElement)this, null, true, new TextRange(startOffsetInParent, startOffsetInParent + psi.getTextLength()))};
                        if (psiReferenceArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelCompositeElementType$1$1", "getReferences"));
                        }
                        return psiReferenceArray;
                    }
                    PsiReference[] psiReferenceArray = super.getReferences();
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelCompositeElementType$1$1", "getReferences"));
                    }
                    return psiReferenceArray;
                }
            };
        }
    };
    public static final TelCompositeElementType REFERENCE_EXPRESSION = new TelCompositeElementType("ReferenceExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new TelReferenceExpression(node);
        }
    };
    public static final TelCompositeElementType ARGUMENT_LIST = new TelCompositeElementType("ArgumentList"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new TelArgumentList(node);
        }
    };
    public static final TelCompositeElementType METHOD_CALL_EXPRESSION = new TelCompositeElementType("MethodCallExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new TelMethodCallExpression(node);
        }
    };
    public static final TelCompositeElementType RANGE_EXPRESSION = new TelCompositeElementType("RangeExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new TelRangeExpression(node);
        }
    };
    public static final TelCompositeElementType NOT_OP_EXPRESSION = new TelCompositeElementType("NotOpExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new TelNotOpExpression(node);
        }
    };
    public static final TelCompositeElementType LIST_EXPRESSION = new TelLiteralExpressionType("ListExpression", "java.util.List");
    public static final TelCompositeElementType STRING_LITERAL = new TelLiteralExpressionType("StringLiteral", "java.lang.String");
    public static final TelCompositeElementType INTEGER_LITERAL = new TelLiteralExpressionType("IntegerLiteral", (PsiType)PsiType.INT);
    public static final TelCompositeElementType DECIMAL_LITERAL = new TelLiteralExpressionType("DoubleLiteral", (PsiType)PsiType.DOUBLE);
    public static final TelCompositeElementType BOOLEAN_LITERAL = new TelLiteralExpressionType("BooleanLiteral", (PsiType)PsiType.BOOLEAN);
    public static final TelCompositeElementType NULL_LITERAL = new TelLiteralExpressionType("NullLiteral", (PsiType)PsiType.NULL);

    TelCompositeElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/tapestry/psi/TelCompositeElementType", "<init>"));
        }
        super(debugName, TelFileType.INSTANCE.getLanguage());
    }

    public abstract PsiElement createPsiElement(ASTNode var1);

    @NotNull
    public ASTNode createCompositeNode() {
        CompositeElement compositeElement = new CompositeElement((IElementType)this);
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelCompositeElementType", "createCompositeNode"));
        }
        return compositeElement;
    }
}

