/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

public class RedundantBoxingMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode node) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "transform"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "transform"));
        }
        RedundantBoxingInterpreter interpreter = new RedundantBoxingInterpreter(node.instructions);
        Frame<BasicValue>[] frames2 = RedundantBoxingMethodTransformer.analyze(internalClassName, node, interpreter);
        RedundantBoxingMethodTransformer.interpretPopInstructionsForBoxedValues(interpreter, node, frames2);
        RedundantBoxedValuesCollection valuesToOptimize = interpreter.getCandidatesBoxedValues();
        if (!valuesToOptimize.isEmpty()) {
            RedundantBoxingMethodTransformer.removeValuesClashingWithVariables(valuesToOptimize, node, frames2);
            RedundantBoxingMethodTransformer.adaptLocalVariableTableForBoxedValues(node, frames2);
            UtilKt.remapLocalVariables(node, RedundantBoxingMethodTransformer.buildVariablesRemapping(valuesToOptimize, node));
            RedundantBoxingMethodTransformer.adaptInstructionsForBoxedValues(node, valuesToOptimize);
        }
    }

    private static void interpretPopInstructionsForBoxedValues(@NotNull RedundantBoxingInterpreter interpreter, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "interpretPopInstructionsForBoxedValues"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "interpretPopInstructionsForBoxedValues"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "interpretPopInstructionsForBoxedValues"));
        }
        for (int i = 0; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (insn.getOpcode() != 87 && insn.getOpcode() != 88 || frames2[i] == null) continue;
            BasicValue top = (BasicValue)frames2[i].getStack(frames2[i].getStackSize() - 1);
            interpreter.processPopInstruction(insn, top);
            if (top.getSize() != 1 || insn.getOpcode() != 88) continue;
            interpreter.processPopInstruction(insn, (BasicValue)frames2[i].getStack(frames2[i].getStackSize() - 2));
        }
    }

    private static void removeValuesClashingWithVariables(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariables"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariables"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariables"));
        }
        while (RedundantBoxingMethodTransformer.removeValuesClashingWithVariablesPass(values, node, frames2)) {
        }
    }

    private static boolean removeValuesClashingWithVariablesPass(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariablesPass"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariablesPass"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariablesPass"));
        }
        boolean needToRepeat = false;
        for (LocalVariableNode localVariableNode : node.localVariables) {
            BoxedValueDescriptor firstBoxed;
            List<BasicValue> variableValues;
            List boxed;
            if (Type.getType((String)localVariableNode.desc).getSort() != 10 || (boxed = CollectionsKt.filter(variableValues = RedundantBoxingMethodTransformer.getValuesStoredOrLoadedToVariable(localVariableNode, node, frames2), (Function1)new Function1<BasicValue, Boolean>(){

                public Boolean invoke(BasicValue value2) {
                    return value2 instanceof BoxedBasicValue;
                }
            })).isEmpty() || !RedundantBoxingMethodTransformer.isUnsafeToRemoveBoxingForConnectedValues(variableValues, (firstBoxed = ((BoxedBasicValue)((Object)boxed.iterator().next())).getDescriptor()).getUnboxedType())) continue;
            for (BasicValue value2 : variableValues) {
                BoxedValueDescriptor descriptor2;
                if (!(value2 instanceof BoxedBasicValue) || !(descriptor2 = ((BoxedBasicValue)value2).getDescriptor()).isSafeToRemove()) continue;
                values.remove(descriptor2);
                needToRepeat = true;
            }
        }
        return needToRepeat;
    }

    private static boolean isUnsafeToRemoveBoxingForConnectedValues(List<BasicValue> usedValues, final Type unboxedType) {
        return CollectionsKt.any(usedValues, (Function1)new Function1<BasicValue, Boolean>(){

            public Boolean invoke(BasicValue input) {
                if (input == StrictBasicValue.UNINITIALIZED_VALUE) {
                    return false;
                }
                if (!(input instanceof BoxedBasicValue)) {
                    return true;
                }
                BoxedValueDescriptor descriptor2 = ((BoxedBasicValue)input).getDescriptor();
                return !descriptor2.isSafeToRemove() || !descriptor2.getUnboxedType().equals((Object)unboxedType);
            }
        });
    }

    private static void adaptLocalVariableTableForBoxedValues(@NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptLocalVariableTableForBoxedValues"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptLocalVariableTableForBoxedValues"));
        }
        for (LocalVariableNode localVariableNode : node.localVariables) {
            if (Type.getType((String)localVariableNode.desc).getSort() != 10) continue;
            for (BasicValue value2 : RedundantBoxingMethodTransformer.getValuesStoredOrLoadedToVariable(localVariableNode, node, frames2)) {
                BoxedValueDescriptor descriptor2;
                if (!(value2 instanceof BoxedBasicValue) || !(descriptor2 = ((BoxedBasicValue)value2).getDescriptor()).isSafeToRemove()) continue;
                localVariableNode.desc = descriptor2.getUnboxedType().getDescriptor();
            }
        }
    }

    @NotNull
    private static List<BasicValue> getValuesStoredOrLoadedToVariable(@NotNull LocalVariableNode localVariableNode, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        BasicValue localVarValue;
        if (localVariableNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localVariableNode", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "getValuesStoredOrLoadedToVariable"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "getValuesStoredOrLoadedToVariable"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "getValuesStoredOrLoadedToVariable"));
        }
        ArrayList<BasicValue> values = new ArrayList<BasicValue>();
        InsnList insnList = node.instructions;
        int from = insnList.indexOf((AbstractInsnNode)localVariableNode.start) + 1;
        int to = insnList.indexOf((AbstractInsnNode)localVariableNode.end) - 1;
        Frame<BasicValue> frameForFromInstr = frames2[from];
        if (frameForFromInstr != null && (localVarValue = (BasicValue)frameForFromInstr.getLocal(localVariableNode.index)) != null) {
            values.add(localVarValue);
        }
        for (int i = from; i <= to; ++i) {
            AbstractInsnNode insn;
            if (i < 0 || i >= insnList.size() || (insn = insnList.get(i)).getOpcode() != 58 && insn.getOpcode() != 25 || ((VarInsnNode)insn).var != localVariableNode.index || frames2[i] == null) continue;
            if (insn.getOpcode() == 58) {
                values.add((BasicValue)frames2[i].getStack(frames2[i].getStackSize() - 1));
                continue;
            }
            values.add((BasicValue)frames2[i].getLocal(((VarInsnNode)insn).var));
        }
        ArrayList<BasicValue> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "getValuesStoredOrLoadedToVariable"));
        }
        return arrayList;
    }

    @NotNull
    private static int[] buildVariablesRemapping(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "buildVariablesRemapping"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "buildVariablesRemapping"));
        }
        HashSet<Integer> doubleSizedVars = new HashSet<Integer>();
        for (BoxedValueDescriptor valueDescriptor : values) {
            if (!valueDescriptor.isDoubleSize()) continue;
            doubleSizedVars.addAll(valueDescriptor.getVariablesIndexes());
        }
        node.maxLocals += doubleSizedVars.size();
        int[] remapping = new int[node.maxLocals];
        for (int i = 0; i < remapping.length; ++i) {
            remapping[i] = i;
        }
        Iterator iterator2 = doubleSizedVars.iterator();
        while (iterator2.hasNext()) {
            int varIndex = (Integer)iterator2.next();
            int i = varIndex + 1;
            while (i < remapping.length) {
                int n = i++;
                remapping[n] = remapping[n] + 1;
            }
        }
        if (remapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "buildVariablesRemapping"));
        }
        return remapping;
    }

    private static void adaptInstructionsForBoxedValues(@NotNull MethodNode node, @NotNull RedundantBoxedValuesCollection values) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstructionsForBoxedValues"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstructionsForBoxedValues"));
        }
        for (BoxedValueDescriptor value2 : values) {
            RedundantBoxingMethodTransformer.adaptInstructionsForBoxedValue(node, value2);
        }
    }

    private static void adaptInstructionsForBoxedValue(@NotNull MethodNode node, @NotNull BoxedValueDescriptor value2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstructionsForBoxedValue"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstructionsForBoxedValue"));
        }
        RedundantBoxingMethodTransformer.adaptBoxingInstruction(node, value2);
        for (Pair<AbstractInsnNode, Type> cast : value2.getUnboxingWithCastInsns()) {
            RedundantBoxingMethodTransformer.adaptCastInstruction(node, value2, cast);
        }
        for (AbstractInsnNode insn : value2.getAssociatedInsns()) {
            RedundantBoxingMethodTransformer.adaptInstruction(node, insn, value2);
        }
    }

    private static void adaptBoxingInstruction(@NotNull MethodNode node, @NotNull BoxedValueDescriptor value2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptBoxingInstruction"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptBoxingInstruction"));
        }
        if (!value2.isFromProgressionIterator()) {
            node.instructions.remove(value2.getBoxingInsn());
        } else {
            ProgressionIteratorBasicValue iterator2 = value2.getProgressionIterator();
            assert (iterator2 != null) : "iterator should not be null because isFromProgressionIterator returns true";
            node.instructions.insertBefore(value2.getBoxingInsn(), (AbstractInsnNode)new TypeInsnNode(192, iterator2.getType().getInternalName()));
            node.instructions.set(value2.getBoxingInsn(), (AbstractInsnNode)new MethodInsnNode(182, iterator2.getType().getInternalName(), iterator2.getNextMethodName(), iterator2.getNextMethodDesc(), false));
        }
    }

    private static void adaptCastInstruction(@NotNull MethodNode node, @NotNull BoxedValueDescriptor value2, @NotNull Pair<AbstractInsnNode, Type> castWithType) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptCastInstruction"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptCastInstruction"));
        }
        if (castWithType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "castWithType", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptCastInstruction"));
        }
        AbstractInsnNode castInsn = (AbstractInsnNode)castWithType.getFirst();
        MethodNode castInsnsListener = new MethodNode(327680);
        new InstructionAdapter((MethodVisitor)castInsnsListener).cast(value2.getUnboxedType(), (Type)castWithType.getSecond());
        for (AbstractInsnNode insn : castInsnsListener.instructions.toArray()) {
            node.instructions.insertBefore(castInsn, insn);
        }
        node.instructions.remove(castInsn);
    }

    private static void adaptInstruction(@NotNull MethodNode node, @NotNull AbstractInsnNode insn, @NotNull BoxedValueDescriptor value2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstruction"));
        }
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstruction"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstruction"));
        }
        boolean isDoubleSize = value2.isDoubleSize();
        switch (insn.getOpcode()) {
            case 87: {
                if (!isDoubleSize) break;
                node.instructions.set(insn, (AbstractInsnNode)new InsnNode(88));
                break;
            }
            case 89: {
                if (!isDoubleSize) break;
                node.instructions.set(insn, (AbstractInsnNode)new InsnNode(92));
                break;
            }
            case 25: 
            case 58: {
                int intVarOpcode = insn.getOpcode() == 58 ? 54 : 21;
                node.instructions.set(insn, (AbstractInsnNode)new VarInsnNode(value2.getUnboxedType().getOpcode(intVarOpcode), ((VarInsnNode)insn).var));
                break;
            }
            case 193: {
                node.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(isDoubleSize ? 88 : 87));
                node.instructions.set(insn, (AbstractInsnNode)new InsnNode(4));
                break;
            }
            case 184: {
                if (BoxingInterpreterKt.isAreEqualIntrinsic(insn)) {
                    RedundantBoxingMethodTransformer.adaptAreEqualIntrinsic(node, insn, value2);
                    break;
                }
            }
            default: {
                node.instructions.remove(insn);
            }
        }
    }

    private static void adaptAreEqualIntrinsic(@NotNull MethodNode node, @NotNull AbstractInsnNode insn, @NotNull BoxedValueDescriptor value2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptAreEqualIntrinsic"));
        }
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptAreEqualIntrinsic"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptAreEqualIntrinsic"));
        }
        Type unboxedType = value2.getUnboxedType();
        switch (unboxedType.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                RedundantBoxingMethodTransformer.adaptAreEqualIntrinsicForInt(node, insn);
                break;
            }
            case 7: {
                RedundantBoxingMethodTransformer.adaptAreEqualIntrinsicForLong(node, insn);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected unboxed type kind: " + unboxedType));
            }
        }
    }

    private static void adaptAreEqualIntrinsicForInt(@NotNull MethodNode node, @NotNull AbstractInsnNode insn) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptAreEqualIntrinsicForInt"));
        }
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptAreEqualIntrinsicForInt"));
        }
        LabelNode lNotEqual = new LabelNode(new Label());
        LabelNode lDone = new LabelNode(new Label());
        node.instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(160, lNotEqual));
        node.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(4));
        node.instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(167, lDone));
        node.instructions.insertBefore(insn, (AbstractInsnNode)lNotEqual);
        node.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(3));
        node.instructions.insertBefore(insn, (AbstractInsnNode)lDone);
        node.instructions.remove(insn);
    }

    private static void adaptAreEqualIntrinsicForLong(@NotNull MethodNode node, @NotNull AbstractInsnNode insn) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptAreEqualIntrinsicForLong"));
        }
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptAreEqualIntrinsicForLong"));
        }
        node.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(148));
        RedundantBoxingMethodTransformer.ifEqual1Else0(node, insn);
        node.instructions.remove(insn);
    }

    private static void ifEqual1Else0(@NotNull MethodNode node, @NotNull AbstractInsnNode insn) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "ifEqual1Else0"));
        }
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "ifEqual1Else0"));
        }
        LabelNode lNotEqual = new LabelNode(new Label());
        LabelNode lDone = new LabelNode(new Label());
        node.instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(154, lNotEqual));
        node.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(4));
        node.instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(167, lDone));
        node.instructions.insertBefore(insn, (AbstractInsnNode)lNotEqual);
        node.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(3));
        node.instructions.insertBefore(insn, (AbstractInsnNode)lDone);
    }
}

