/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;

public final class OldPackageFacadeClassUtils {
    private static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    private static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";

    private OldPackageFacadeClassUtils() {
    }

    @NotNull
    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/kotlin/fileClasses/OldPackageFacadeClassUtils", "getPackageClassName"));
        }
        if (packageFQN.isRoot()) {
            if (DEFAULT_PACKAGE_CLASS_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/fileClasses/OldPackageFacadeClassUtils", "getPackageClassName"));
            }
            return DEFAULT_PACKAGE_CLASS_NAME;
        }
        String string = OldPackageFacadeClassUtils.capitalizeNonEmptyString(packageFQN.shortName().asString()) + PACKAGE_CLASS_NAME_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/fileClasses/OldPackageFacadeClassUtils", "getPackageClassName"));
        }
        return string;
    }

    @NotNull
    private static String capitalizeNonEmptyString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/fileClasses/OldPackageFacadeClassUtils", "capitalizeNonEmptyString"));
        }
        String string = Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/fileClasses/OldPackageFacadeClassUtils", "capitalizeNonEmptyString"));
        }
        return string;
    }
}

