/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.dependencies.KotlinScriptExternalDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.resolve.ScriptDependenciesSourceModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ScriptModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.resolve.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptConfigurationManager;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u001fH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020%H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/ScriptDependenciesModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/resolve/BinaryModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "dependencies", "Lkotlin/script/dependencies/KotlinScriptExternalDependencies;", "scriptModuleInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/ScriptModuleInfo;", "(Lcom/intellij/openapi/project/Project;Lkotlin/script/dependencies/KotlinScriptExternalDependencies;Lorg/jetbrains/kotlin/idea/caches/resolve/ScriptModuleInfo;)V", "getDependencies", "()Lkotlin/script/dependencies/KotlinScriptExternalDependencies;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScriptModuleInfo", "()Lorg/jetbrains/kotlin/idea/caches/resolve/ScriptModuleInfo;", "sourcesModuleInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/SourceForBinaryModuleInfo;", "getSourcesModuleInfo", "()Lorg/jetbrains/kotlin/idea/caches/resolve/SourceForBinaryModuleInfo;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "", "equals", "", "other", "", "hashCode", "", "idea-analysis"})
public final class ScriptDependenciesModuleInfo
implements IdeaModuleInfo,
BinaryModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @Nullable
    private final KotlinScriptExternalDependencies dependencies;
    @Nullable
    private final ScriptModuleInfo scriptModuleInfo;

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this), (Iterable)ScriptModuleInfosKt.access$sdkDependencies(this.dependencies, this.project));
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        if (this.dependencies == null) {
            return KotlinSourceFilterScope.Companion.libraryClassFiles((GlobalSearchScope)KotlinScriptConfigurationManager.Companion.getInstance(this.project).getAllScriptsClasspathScope(), this.project);
        }
        List<VirtualFile> classpath = KotlinScriptConfigurationManager.Companion.toVfsRoots(this.dependencies.getClasspath());
        return KotlinSourceFilterScope.Companion.libraryClassFiles((GlobalSearchScope)new NonClasspathDirectoriesScope((Collection)classpath), this.project);
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ScriptDependenciesModuleInfo && Intrinsics.areEqual((Object)this.project, (Object)((ScriptDependenciesModuleInfo)other).project);
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @Override
    @Nullable
    public SourceForBinaryModuleInfo getSourcesModuleInfo() {
        return new ScriptDependenciesSourceModuleInfo(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final KotlinScriptExternalDependencies getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public final ScriptModuleInfo getScriptModuleInfo() {
        return this.scriptModuleInfo;
    }

    public ScriptDependenciesModuleInfo(@NotNull Project project, @Nullable KotlinScriptExternalDependencies dependencies2, @Nullable ScriptModuleInfo scriptModuleInfo) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.dependencies = dependencies2;
        this.scriptModuleInfo = scriptModuleInfo;
        this.name = Name.special("<Script dependencies>");
    }

    @Override
    @NotNull
    public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @Override
    public boolean isLibrary() {
        return IdeaModuleInfo.DefaultImpls.isLibrary(this);
    }

    @Override
    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @Override
    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return IdeaModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope binariesScope() {
        return BinaryModuleInfo.DefaultImpls.binariesScope(this);
    }
}

