/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.google.common.collect.Maps;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallerMethodsTreeStructure;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.hierarchy.HierarchyUtilsKt;
import org.jetbrains.kotlin.idea.hierarchy.calls.CalleeReferenceVisitorBase;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallTreeStructure;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinCallerMethodsTreeStructure
extends KotlinCallTreeStructure {
    private final CallerMethodsTreeStructure javaTreeStructure;
    private final PsiClass basePsiClass;

    public KotlinCallerMethodsTreeStructure(@NotNull Project project, @NotNull PsiElement element2, String scopeType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "<init>"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "<init>"));
        }
        super(project, element2, scopeType);
        PsiMethod basePsiMethod = KotlinCallerMethodsTreeStructure.getRepresentativePsiMethod(element2);
        assert (basePsiMethod != null) : "Can't generate light method: " + element2.getText();
        this.basePsiClass = basePsiMethod.getContainingClass();
        this.javaTreeStructure = new CallerMethodsTreeStructure(project, basePsiMethod, scopeType);
    }

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "buildChildren"));
        }
        final PsiElement element2 = KotlinCallerMethodsTreeStructure.getTargetElement(descriptor2);
        KtElement codeBlockForLocalDeclaration = KotlinCallerMethodsTreeStructure.getEnclosingElementForLocalDeclaration(element2);
        if (codeBlockForLocalDeclaration != null) {
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)element2, BodyResolveMode.FULL);
            com.intellij.util.containers.HashMap referencesToElements = new com.intellij.util.containers.HashMap();
            codeBlockForLocalDeclaration.accept(new CalleeReferenceVisitorBase(bindingContext2, true, (Map)referencesToElements){
                final /* synthetic */ Map val$referencesToElements;
                {
                    this.val$referencesToElements = map2;
                    super(bindingContext2, deepTraversal);
                }

                @Override
                protected void processDeclaration(KtSimpleNameExpression reference2, PsiElement declaration2) {
                    if (!declaration2.equals(element2)) {
                        return;
                    }
                    PsiElement container2 = PsiTreeUtil.getParentOfType((PsiElement)reference2, (Class[])new Class[]{KtNamedFunction.class, KtPropertyAccessor.class, KtClassOrObject.class});
                    if (container2 instanceof KtPropertyAccessor) {
                        container2 = PsiTreeUtil.getParentOfType((PsiElement)container2, KtProperty.class);
                    }
                    if (container2 != null) {
                        this.val$referencesToElements.put(ReferenceUtilKt.getMainReference(reference2), container2);
                    }
                }
            });
            Object[] objectArray = this.collectNodeDescriptors(descriptor2, (Map<PsiReference, PsiElement>)referencesToElements, null);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "buildChildren"));
            }
            return objectArray;
        }
        SearchScope searchScope2 = this.getSearchScope(this.scopeType, (PsiElement)this.basePsiClass);
        HashMap methodToDescriptorMap = Maps.newHashMap();
        Object[] javaCallers = null;
        if (element2 instanceof PsiMethod) {
            javaCallers = this.javaTreeStructure.getChildElements((Object)KotlinCallerMethodsTreeStructure.getJavaNodeDescriptor(descriptor2));
            KotlinCallerMethodsTreeStructure.processPsiMethodCallers(Collections.singleton((PsiMethod)element2), descriptor2, methodToDescriptorMap, searchScope2, true);
        }
        if (element2 instanceof KtNamedFunction || element2 instanceof KtSecondaryConstructor) {
            List<PsiMethod> lightMethods = LightClassUtil.INSTANCE.getLightClassMethods((KtFunction)element2);
            KotlinCallerMethodsTreeStructure.processPsiMethodCallers(lightMethods, descriptor2, methodToDescriptorMap, searchScope2, false);
        }
        if (element2 instanceof KtProperty) {
            LightClassUtil.PropertyAccessorsPsiMethods propertyMethods2 = LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)element2);
            KotlinCallerMethodsTreeStructure.processPsiMethodCallers(propertyMethods2, descriptor2, methodToDescriptorMap, searchScope2, false);
        }
        if (element2 instanceof KtClassOrObject) {
            KtPrimaryConstructor constructor2 = ((KtClassOrObject)element2).getPrimaryConstructor();
            if (constructor2 != null) {
                PsiMethod lightMethod = LightClassUtil.INSTANCE.getLightClassMethod(constructor2);
                KotlinCallerMethodsTreeStructure.processPsiMethodCallers(Collections.singleton(lightMethod), descriptor2, methodToDescriptorMap, searchScope2, false);
            } else {
                KotlinCallerMethodsTreeStructure.processKtClassOrObjectCallers((KtClassOrObject)element2, descriptor2, methodToDescriptorMap, searchScope2);
            }
        }
        Object[] callers = methodToDescriptorMap.values().toArray(new Object[methodToDescriptorMap.size()]);
        Object[] objectArray = javaCallers != null ? ArrayUtil.mergeArrays((Object[])javaCallers, (Object[])callers) : callers;
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    private static void processPsiMethodCallers(Iterable<PsiMethod> lightMethods, HierarchyNodeDescriptor descriptor2, Map<PsiElement, HierarchyNodeDescriptor> methodToDescriptorMap, SearchScope searchScope2, boolean kotlinOnly) {
        HashSet<PsiMethod> methodsToFind = new HashSet<PsiMethod>();
        for (PsiMethod lightMethod : lightMethods) {
            if (lightMethod == null) continue;
            Object[] superMethods = lightMethod.findDeepestSuperMethods();
            methodsToFind.add(lightMethod);
            ContainerUtil.addAll(methodsToFind, (Object[])superMethods);
        }
        if (methodsToFind.isEmpty()) {
            return;
        }
        THashSet references2 = ContainerUtil.newTroveSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiReference>(){

            public int computeHashCode(PsiReference object) {
                return object.getElement().hashCode();
            }

            public boolean equals(PsiReference o1, PsiReference o2) {
                return o1.getElement().equals(o2.getElement());
            }
        });
        for (PsiMethod superMethod : methodsToFind) {
            ContainerUtil.addAll((Collection)references2, (Iterable)MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)searchScope2, (boolean)true));
        }
        ContainerUtil.process((Iterable)references2, KotlinCallerMethodsTreeStructure.defaultQueryProcessor(descriptor2, methodToDescriptorMap, kotlinOnly, false));
    }

    private static void processKtClassOrObjectCallers(final KtClassOrObject classOrObject, HierarchyNodeDescriptor descriptor2, Map<PsiElement, HierarchyNodeDescriptor> methodToDescriptorMap, SearchScope searchScope2) {
        FilteringProcessor processor2 = new FilteringProcessor((Condition)new Condition<PsiReference>(){

            public boolean value(PsiReference reference2) {
                return UtilsKt.isConstructorUsage(reference2, classOrObject);
            }
        }, KotlinCallerMethodsTreeStructure.defaultQueryProcessor(descriptor2, methodToDescriptorMap, false, false));
        ReferencesSearch.search((PsiElement)classOrObject, (SearchScope)searchScope2, (boolean)false).forEach((Processor)processor2);
    }

    static Processor<PsiReference> defaultQueryProcessor(final HierarchyNodeDescriptor descriptor2, final Map<PsiElement, HierarchyNodeDescriptor> methodToDescriptorMap, boolean kotlinOnly, final boolean wrapAsLightElements) {
        return new CalleeReferenceProcessor(kotlinOnly){

            @Override
            protected void onAccept(@NotNull PsiReference ref, @NotNull PsiElement element2) {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure$4", "onAccept"));
                }
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallerMethodsTreeStructure$4", "onAccept"));
                }
                KotlinCallTreeStructure.addNodeDescriptorForElement(ref, element2, methodToDescriptorMap, descriptor2, wrapAsLightElements);
            }
        };
    }

    public static abstract class CalleeReferenceProcessor
    extends ReadActionProcessor<PsiReference> {
        private final boolean kotlinOnly;

        public CalleeReferenceProcessor(boolean only) {
            this.kotlinOnly = only;
        }

        public boolean processInReadAction(PsiReference ref) {
            KtProperty property2;
            PsiElement refElement;
            if (!(ref instanceof PsiReferenceExpression) && !(ref instanceof KtReference)) {
                if (!(ref instanceof PsiElement)) {
                    return true;
                }
                PsiElement parent2 = ((PsiElement)ref).getParent();
                if (parent2 instanceof PsiNewExpression) {
                    if (((PsiNewExpression)parent2).getClassReference() != ref) {
                        return true;
                    }
                } else if (parent2 instanceof PsiAnonymousClass) {
                    if (((PsiAnonymousClass)parent2).getBaseClassReference() != ref) {
                        return true;
                    }
                } else if (ref instanceof LightMemberReference) {
                    PsiElement refTarget = ref.resolve();
                    if (!(refTarget instanceof PsiMethod) || !((PsiMethod)refTarget).isConstructor()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)(refElement = ref.getElement()), KtImportDirective.class, (boolean)true) != null) {
                return true;
            }
            PsiElement element2 = HierarchyUtilsKt.getCallHierarchyElement(refElement);
            if (this.kotlinOnly && !(element2 instanceof KtNamedDeclaration)) {
                return true;
            }
            if (element2 instanceof KtProperty && PsiTreeUtil.isAncestor((PsiElement)(property2 = (KtProperty)element2).getInitializer(), (PsiElement)refElement, (boolean)false)) {
                element2 = HierarchyUtilsKt.getCallHierarchyElement(element2.getParent());
            }
            if (element2 != null) {
                this.onAccept(ref, element2);
            }
            return true;
        }

        protected abstract void onAccept(@NotNull PsiReference var1, @NotNull PsiElement var2);
    }
}

